/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.wicket.markup.html.WebResource;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public abstract class DynamicWebResource
extends WebResource {
    private static final long serialVersionUID = 1L;
    private final Locale locale;
    private final String filename;

    public DynamicWebResource() {
        this(null, null);
    }

    public DynamicWebResource(String filename) {
        this(null, filename);
    }

    public DynamicWebResource(Locale locale) {
        this(locale, null);
    }

    public DynamicWebResource(Locale locale, String filename) {
        this.locale = locale;
        this.filename = filename;
        this.setCacheable(false);
    }

    protected void setHeaders(WebResponse response) {
        super.setHeaders(response);
        if (this.filename != null) {
            response.setAttachmentHeader(this.filename);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public IResourceStream getResourceStream() {
        return new IResourceStream(){
            private static final long serialVersionUID = 1L;
            private Locale locale;
            private transient InputStream inputStream;
            private transient ResourceState data;
            {
                this.locale = DynamicWebResource.this.getLocale();
                this.inputStream = null;
                this.data = null;
            }

            public void close() throws IOException {
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                this.data = null;
            }

            public String getContentType() {
                this.checkLoadData();
                return this.data.getContentType();
            }

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                this.checkLoadData();
                if (this.inputStream == null) {
                    this.inputStream = new ByteArrayInputStream(this.data.getData());
                }
                return this.inputStream;
            }

            public Time lastModifiedTime() {
                this.checkLoadData();
                return this.data.lastModifiedTime();
            }

            public long length() {
                this.checkLoadData();
                return this.data.getLength();
            }

            public Locale getLocale() {
                return this.locale;
            }

            public void setLocale(Locale loc) {
                this.locale = loc;
            }

            private void checkLoadData() {
                if (this.data == null) {
                    this.data = DynamicWebResource.this.getResourceState();
                }
            }
        };
    }

    protected abstract ResourceState getResourceState();

    public static abstract class ResourceState {
        protected Time lastModifiedTime;

        public abstract byte[] getData();

        public abstract String getContentType();

        public Time lastModifiedTime() {
            if (this.lastModifiedTime == null) {
                this.lastModifiedTime = Time.now();
            }
            return this.lastModifiedTime;
        }

        public int getLength() {
            byte[] data = this.getData();
            return data != null ? data.length : 0;
        }
    }
}

