/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Session;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.upload.FileItem;

public class FileUpload
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final FileItem item;
    private transient List inputStreamsToClose;

    public FileUpload(FileItem item) {
        this.item = item;
    }

    public final void closeStreams() {
        if (this.inputStreamsToClose != null) {
            Iterator inputStreamsIterator = this.inputStreamsToClose.iterator();
            while (inputStreamsIterator.hasNext()) {
                InputStream inputStream = (InputStream)inputStreamsIterator.next();
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.inputStreamsToClose = null;
        }
    }

    public void delete() {
        this.item.delete();
    }

    public byte[] getBytes() {
        return this.item.get();
    }

    public String getClientFileName() {
        return this.item.getName();
    }

    public String getContentType() {
        return this.item.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStreamsToClose == null) {
            this.inputStreamsToClose = new ArrayList();
        }
        InputStream is = this.item.getInputStream();
        this.inputStreamsToClose.add(is);
        return is;
    }

    public long getSize() {
        return this.item.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) throws IOException {
        InputStream is = this.getInputStream();
        try {
            Files.writeTo(file, is);
        }
        finally {
            is.close();
        }
    }

    public final File writeToTempFile() throws IOException {
        File temp = File.createTempFile(Session.get().getId(), Files.cleanupFilename(this.item.getFieldName()));
        this.writeTo(temp);
        return temp;
    }
}

