/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component;

import java.lang.ref.WeakReference;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;

public class BookmarkablePageRequestTarget
implements IBookmarkablePageRequestTarget {
    private Page page;
    private final WeakReference pageClassRef;
    private final String pageMapName;
    private final PageParameters pageParameters;

    public BookmarkablePageRequestTarget(Class pageClass) {
        this(null, pageClass);
    }

    public BookmarkablePageRequestTarget(Class pageClass, PageParameters pageParameters) {
        this(null, pageClass, pageParameters);
    }

    public BookmarkablePageRequestTarget(String pageMapName, Class pageClass) {
        this(null, pageClass, null);
    }

    public BookmarkablePageRequestTarget(String pageMapName, Class pageClass, PageParameters pageParameters) {
        if (pageClass == null) {
            throw new IllegalArgumentException("Argument pageClass must be not null");
        }
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("Argument pageClass must be an instance of " + Page.class.getName());
        }
        this.pageClassRef = new WeakReference<Class>(pageClass);
        this.pageParameters = pageParameters == null ? new PageParameters() : pageParameters;
        this.pageMapName = pageMapName;
    }

    public void detach(RequestCycle requestCycle) {
        if (this.page != null) {
            this.page.detach();
        }
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj instanceof BookmarkablePageRequestTarget) {
            BookmarkablePageRequestTarget that = (BookmarkablePageRequestTarget)obj;
            if (this.getPageClass().equals(that.getPageClass())) {
                boolean mapMatch = false;
                mapMatch = this.pageMapName != null ? that.pageMapName != null && this.pageMapName.equals(that.pageMapName) : that.pageMapName == null;
                equal = mapMatch;
            }
        }
        return equal;
    }

    public final Page getPage() {
        return this.page;
    }

    protected final void setPage(Page page) {
        this.page = page;
    }

    public final Class getPageClass() {
        return (Class)this.pageClassRef.get();
    }

    public final String getPageMapName() {
        return this.pageMapName;
    }

    public final PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public int hashCode() {
        int result = "BookmarkablePageRequestTarget".hashCode();
        result += this.getPageClass().hashCode();
        return 17 * (result += this.pageMapName != null ? this.pageMapName.hashCode() : 0);
    }

    public void processEvents(RequestCycle requestCycle) {
        if (!requestCycle.isRedirect()) {
            this.page = this.getPage(requestCycle);
        }
    }

    public void respond(RequestCycle requestCycle) {
        if (this.pageClassRef != null && this.pageClassRef.get() != null) {
            if (requestCycle.isRedirect()) {
                IRequestCycleProcessor processor = requestCycle.getProcessor();
                String redirectUrl = ((Object)processor.getRequestCodingStrategy().encode(requestCycle, this)).toString();
                if (redirectUrl.startsWith("./") && redirectUrl.length() > 2) {
                    redirectUrl = redirectUrl.substring(2);
                }
                requestCycle.getResponse().redirect(redirectUrl);
            } else {
                this.getPage(requestCycle).renderPage();
            }
        }
    }

    public String toString() {
        return "[BookmarkablePageRequestTarget@" + this.hashCode() + " pageClass=" + this.getPageClass().getName() + "]";
    }

    protected Page newPage(Class pageClass, RequestCycle requestCycle) {
        IPageFactory pageFactory = requestCycle.getApplication().getSessionSettings().getPageFactory();
        if (this.pageParameters == null || this.pageParameters.size() == 0) {
            return pageFactory.newPage(pageClass);
        }
        requestCycle.getRequest().getParameterMap().putAll(this.pageParameters);
        return pageFactory.newPage(pageClass, this.pageParameters);
    }

    protected final Page getPage(RequestCycle requestCycle) {
        if (this.page == null && !requestCycle.isRedirect()) {
            this.page = this.newPage(this.getPageClass(), requestCycle);
        }
        return this.page;
    }
}

