/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.util.LinkedHashMap;
import java.util.Map;

public class MostRecentlyUsedMap
extends LinkedHashMap {
    private static final long serialVersionUID = 1L;
    Object removedValue;
    private final int maxEntries;

    public MostRecentlyUsedMap(int maxEntries) {
        super(10, 0.75f, true);
        if (maxEntries <= 0) {
            throw new IllegalArgumentException("Must have at least one entry");
        }
        this.maxEntries = maxEntries;
    }

    public Object getRemovedValue() {
        return this.removedValue;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        boolean remove = this.size() > this.maxEntries;
        this.removedValue = remove ? eldest.getValue() : null;
        return remove;
    }
}

