/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.validation.ValidationDoctype;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidationEntityResolver
implements EntityResolver {
    private static Logger log = LoggerFactory.getLogger(ValidationEntityResolver.class);
    private static Hashtable entities = new Hashtable();
    private ValidationDoctype doctype = null;
    private static URL DTD_ROOT_URL = null;

    public ValidationEntityResolver() throws FileNotFoundException {
        if (DTD_ROOT_URL != null) {
            return;
        }
        log.debug("/ is " + ValidationEntityResolver.class.getResource("/"));
        throw new FileNotFoundException("Could not find dtds folder " + DTD_ROOT_URL);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String entity = null;
        if (this.doctype == null) {
            this.doctype = new ValidationDoctype(publicId, systemId);
        }
        if (log.isDebugEnabled()) {
            log.debug("resolveEntity('" + publicId + "', '" + systemId + "')");
        }
        if (publicId != null && publicId.startsWith("-//W3C//")) {
            systemId = "-//W3C//ENTITIES Latin 1 for XHTML//EN".equals(publicId) ? DTD_ROOT_URL + "/www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent" : ValidationEntityResolver.convertFromFilePath(systemId);
        }
        if (publicId != null) {
            entity = (String)entities.get(publicId);
        }
        if (systemId != null && entity == null) {
            entity = (String)entities.get(systemId);
        }
        if (entity == null && systemId != null) {
            entity = systemId.startsWith("http://") ? ValidationEntityResolver.convertToSystemPath(systemId) : systemId;
            try {
                if (publicId != null) {
                    ValidationEntityResolver.register(publicId, entity);
                } else {
                    ValidationEntityResolver.register(systemId, entity);
                }
            }
            catch (MalformedURLException e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        if (entity == null) {
            if (log.isDebugEnabled()) {
                log.debug("Couldn't resolve DTD: " + publicId + ", " + systemId);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Resolving to DTD " + entity);
        }
        return new InputSource(entity);
    }

    static String convertToSystemPath(String systemId) {
        String dtdPath = systemId.substring("http://".length());
        int pathIdx = dtdPath.indexOf("/");
        String dtdHost = dtdPath.substring(0, pathIdx);
        String entity = dtdPath.substring(pathIdx);
        entity = dtdHost + entity;
        if (!DTD_ROOT_URL.toString().endsWith("/")) {
            entity = "/" + entity;
        }
        return DTD_ROOT_URL + entity;
    }

    static String convertFromFilePath(String systemId) {
        String rootUrlStr = ValidationEntityResolver.class.getResource("/").toString();
        if (!systemId.startsWith("file:/")) {
            return systemId;
        }
        int idx = systemId.indexOf(rootUrlStr);
        if (idx != 0) {
            return systemId;
        }
        String entityUri = systemId.substring(rootUrlStr.length());
        if (entityUri.startsWith("org/tuckey/")) {
            return systemId;
        }
        if (!DTD_ROOT_URL.toString().endsWith("/")) {
            entityUri = "/" + entityUri;
        }
        return DTD_ROOT_URL + entityUri;
    }

    public static void register(String publicId, String entityURL) throws MalformedURLException {
        if (log.isDebugEnabled()) {
            log.debug("register " + publicId + ", " + entityURL);
        }
        URL dtdURL = new URL(entityURL);
        if (log.isDebugEnabled()) {
            log.debug("url '" + dtdURL + "'");
        }
        entities.put(publicId, entityURL);
    }

    public ValidationDoctype getDoctype() {
        return this.doctype;
    }

    static {
        DTD_ROOT_URL = ValidationEntityResolver.class.getResource("/org/tuckey/web/filters/validation/dtds");
    }
}

