/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import org.geotools.data.jdbc.ConnectionPool;

public class ConnectionPoolManager {
    private static ConnectionPoolManager instance;
    private Map connectionPools = new HashMap();

    private ConnectionPoolManager() {
    }

    public static synchronized ConnectionPoolManager getInstance() {
        if (instance == null) {
            instance = new ConnectionPoolManager();
        }
        return instance;
    }

    public synchronized ConnectionPool getConnectionPool(ConnectionPoolDataSource cpds) {
        ConnectionPool connectionPool = (ConnectionPool)this.connectionPools.get(cpds);
        if (connectionPool == null) {
            connectionPool = new ConnectionPool(cpds);
            this.connectionPools.put(cpds, connectionPool);
        }
        return connectionPool;
    }

    public synchronized void free(ConnectionPool pool) {
        if (!pool.isClosed()) {
            pool.close();
        }
        this.connectionPools.values().remove(pool);
    }

    public synchronized void closeAll() {
        Iterator iter = this.connectionPools.values().iterator();
        while (iter.hasNext()) {
            ConnectionPool pool = (ConnectionPool)iter.next();
            iter.remove();
            pool.close();
        }
    }
}

