/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public abstract class JDBCJNDIDataStoreFactory
extends JDBCDataStoreFactory {
    public static final String J2EERootContext = "java:comp/env/";
    public static final DataAccessFactory.Param JNDI_REFNAME = new DataAccessFactory.Param("jndiReferenceName", String.class, "JNDI data source", true, (Object)"java:comp/env/jdbc/mydatabase");
    protected JDBCDataStoreFactory delegate;

    protected JDBCJNDIDataStoreFactory(JDBCDataStoreFactory delegate) {
        this.delegate = delegate;
    }

    protected String getDriverClassName() {
        return null;
    }

    protected String getValidationQuery() {
        return null;
    }

    protected String getJDBCUrl(Map params) throws IOException {
        return null;
    }

    protected DataSource createDataSource(Map params, SQLDialect dialect) throws IOException {
        String jndiName = (String)JNDI_REFNAME.lookUp(params);
        if (jndiName == null) {
            throw new IOException("Missing " + JDBCJNDIDataStoreFactory.JNDI_REFNAME.description);
        }
        InitialContext ctx = null;
        DataSource ds = null;
        try {
            ctx = GeoTools.getInitialContext((Hints)GeoTools.getDefaultHints());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        try {
            ds = (DataSource)ctx.lookup(jndiName);
        }
        catch (NamingException e1) {
            try {
                if (!jndiName.startsWith(J2EERootContext)) {
                    ds = (DataSource)ctx.lookup(J2EERootContext + jndiName);
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Using java:comp/env/" + jndiName + " instead of " + jndiName + " would avoid an unnecessary JNDI lookup");
                }
            }
            catch (NamingException e2) {
                // empty catch block
            }
        }
        if (ds == null) {
            throw new IOException("Cannot find JNDI data source: " + jndiName);
        }
        return ds;
    }

    public boolean isAvailable() {
        try {
            GeoTools.getInitialContext((Hints)GeoTools.getDefaultHints());
            return true;
        }
        catch (NamingException e) {
            return false;
        }
    }

    protected void setupParameters(Map parameters) {
        parameters.put(JDBCJNDIDataStoreFactory.DBTYPE.key, new DataAccessFactory.Param(JDBCJNDIDataStoreFactory.DBTYPE.key, JDBCJNDIDataStoreFactory.DBTYPE.type, JDBCJNDIDataStoreFactory.DBTYPE.description, JDBCJNDIDataStoreFactory.DBTYPE.required, (Object)this.getDatabaseID()));
        parameters.put(JDBCJNDIDataStoreFactory.JNDI_REFNAME.key, JNDI_REFNAME);
        parameters.put(JDBCJNDIDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(JDBCJNDIDataStoreFactory.NAMESPACE.key, NAMESPACE);
        parameters.put(JDBCJNDIDataStoreFactory.PK_METADATA_TABLE.key, PK_METADATA_TABLE);
    }

    protected String getDatabaseID() {
        return this.delegate.getDatabaseID();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName() + " (JNDI)";
    }

    public String getDescription() {
        return this.delegate.getDescription() + " (JNDI)";
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        return this.delegate.createDataStoreInternal(dataStore, params);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        return this.delegate.createNewDataStore(params);
    }

    public Map getImplementationHints() {
        return this.delegate.getImplementationHints();
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return this.delegate.createSQLDialect(dataStore);
    }
}

