/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.EncodingInfo;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geoserver.platform.GeoServerResourceLoader;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FilePublisher
extends AbstractController {
    protected GeoServerResourceLoader loader;

    public FilePublisher(GeoServerResourceLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long lastModified;
        long length;
        File file;
        String ctxPath = request.getContextPath();
        String reqPath = request.getRequestURI();
        if ((reqPath = reqPath.substring(ctxPath.length())).length() > 1 && reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if ((file = this.loader.find(reqPath)) == null) {
            response.sendError(404);
            return null;
        }
        if (file.isDirectory()) {
            String uri = request.getRequestURI().toString();
            uri = uri + (uri.endsWith("/") ? "index.html" : "/index.html");
            response.addHeader("Location", uri);
            response.sendError(302);
            return null;
        }
        String mime = this.getServletContext().getMimeType(file.getName());
        if (mime != null) {
            response.setContentType(mime);
        }
        if ((length = file.length()) > 0L && length <= Integer.MAX_VALUE) {
            response.setContentLength((int)length);
        }
        if ((lastModified = file.lastModified()) > 0L) {
            SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            String formatted = format.format(new Date(lastModified)) + " GMT";
            response.setHeader("Last-Modified", formatted);
        }
        EncodingInfo encInfo = null;
        FileInputStream input = null;
        OutputStream output = null;
        byte[] b4 = new byte[4];
        int count = 0;
        try {
            input = new FileInputStream(file);
            count = input.read(b4);
            encInfo = XmlCharsetDetector.getEncodingName(b4, count);
            response.setCharacterEncoding(encInfo.getEncoding() != null ? encInfo.getEncoding() : "UTF-8");
            output = response.getOutputStream();
            output.write(b4, 0, count);
            byte[] buffer = new byte[8192];
            int n = -1;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                output.flush();
            }
            if (input != null) {
                input.close();
            }
        }
        return null;
    }
}

