/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.ows.ServiceException;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCapabilitiesConfiguration
implements Configuration {
    private static Log log = LogFactory.getLog(GetCapabilitiesConfiguration.class);
    private GridSetBroker gridSetBroker;
    private String url = null;
    private String mimeTypes = null;
    private String metaTiling = null;
    private String vendorParameters = null;
    private boolean allowCacheBypass = false;

    public GetCapabilitiesConfiguration(GridSetBroker gridSetBroker, String url, String mimeTypes, String metaTiling, String allowCacheBypass) {
        this.gridSetBroker = gridSetBroker;
        this.url = url;
        this.mimeTypes = mimeTypes;
        this.metaTiling = metaTiling;
        if (Boolean.parseBoolean(allowCacheBypass)) {
            this.allowCacheBypass = true;
        }
        log.info((Object)("Constructing from url " + url));
    }

    public GetCapabilitiesConfiguration(GridSetBroker gridSetBroker, String url, String mimeTypes, String metaTiling, String vendorParameters, String allowCacheBypass) {
        this.gridSetBroker = gridSetBroker;
        this.url = url;
        this.mimeTypes = mimeTypes;
        this.metaTiling = metaTiling;
        this.vendorParameters = vendorParameters;
        if (Boolean.parseBoolean(allowCacheBypass)) {
            this.allowCacheBypass = true;
        }
        log.info((Object)("Constructing from url " + url));
    }

    @Override
    public String getIdentifier() {
        return this.url;
    }

    @Override
    public synchronized List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        List<TileLayer> layers = null;
        WebMapServer wms = this.getWMS();
        if (wms == null) {
            throw new ConfigurationException("Unable to connect to " + this.url);
        }
        String wmsUrl = this.getWMSUrl(wms);
        log.info((Object)("Using " + wmsUrl + " to generate URLs for WMS requests"));
        String urlVersion = this.parseVersion(this.url);
        layers = this.getLayers(wms, wmsUrl, urlVersion);
        if (layers == null || layers.size() < 1) {
            log.error((Object)("Unable to find any layers based on " + this.url));
        } else {
            log.info((Object)("Loaded " + layers.size() + " layers from " + this.url));
        }
        return layers;
    }

    @Override
    public ServiceInformation getServiceInformation() throws GeoWebCacheException {
        return null;
    }

    private String getWMSUrl(WebMapServer wms) {
        String preQuery;
        String wmsUrl = wms.getCapabilities().getRequest().getGetCapabilities().getGet().toString();
        int queryStart = wmsUrl.lastIndexOf("?");
        if (queryStart > 0 && (preQuery = wmsUrl.substring(queryStart)).equalsIgnoreCase("?service=wms&")) {
            wmsUrl = wmsUrl.substring(0, wmsUrl.lastIndexOf("?"));
        }
        return wmsUrl;
    }

    private List<TileLayer> getLayers(WebMapServer wms, String wmsUrl, String urlVersion) throws GeoWebCacheException {
        LinkedList<TileLayer> layers = new LinkedList<TileLayer>();
        WMSCapabilities capabilities = wms.getCapabilities();
        if (capabilities == null) {
            throw new ConfigurationException("Unable to get capabitilies from " + wmsUrl);
        }
        WMSHttpHelper sourceHelper = new WMSHttpHelper();
        List layerList = capabilities.getLayerList();
        for (Layer layer : layerList) {
            String name = layer.getName();
            String stylesStr = "";
            boolean queryable = layer.isQueryable();
            if (name == null) continue;
            List styles = layer.getStyles();
            StringBuffer buf = new StringBuffer();
            if (styles != null) {
                Iterator iter = styles.iterator();
                boolean hasOne = false;
                while (iter.hasNext()) {
                    if (hasOne) {
                        buf.append(",");
                    }
                    buf.append(((StyleImpl)iter.next()).getName());
                    hasOne = true;
                }
                stylesStr = buf.toString();
            }
            double minX = layer.getLatLonBoundingBox().getMinX();
            double minY = layer.getLatLonBoundingBox().getMinY();
            double maxX = layer.getLatLonBoundingBox().getMaxX();
            double maxY = layer.getLatLonBoundingBox().getMaxY();
            BoundingBox bounds4326 = new BoundingBox(minX, minY, maxX, maxY);
            log.info((Object)("Found layer: " + layer.getName() + " with LatLon bbox " + bounds4326.toString()));
            BoundingBox bounds3785 = new BoundingBox(this.longToSphericalMercatorX(minX), this.latToSphericalMercatorY(minY), this.longToSphericalMercatorX(maxX), this.latToSphericalMercatorY(maxY));
            String[] wmsUrls = new String[]{wmsUrl};
            WMSLayer wmsLayer = null;
            try {
                wmsLayer = this.getLayer(name, wmsUrls, bounds4326, bounds3785, stylesStr, queryable, layer.getBoundingBoxes());
            }
            catch (GeoWebCacheException gwc) {
                log.error((Object)("Error creating " + layer.getName() + ": " + gwc.getMessage()));
            }
            if (wmsLayer == null) continue;
            wmsLayer.setCacheBypassAllowed(this.allowCacheBypass);
            wmsLayer.setBackendTimeout(120);
            if (urlVersion != null) {
                wmsLayer.setVersion(urlVersion);
            } else {
                String wmsVersion = capabilities.getVersion();
                if (wmsVersion != null && wmsVersion.length() > 0) {
                    wmsLayer.setVersion(wmsVersion);
                }
            }
            wmsLayer.setSourceHelper(sourceHelper);
            layers.add(wmsLayer);
        }
        return layers;
    }

    private WMSLayer getLayer(String name, String[] wmsurl, BoundingBox bounds4326, BoundingBox bounds3785, String stylesStr, boolean queryable, HashMap<Object, CRSEnvelope> additionalBounds) throws GeoWebCacheException {
        Hashtable<String, GridSubset> grids = new Hashtable<String, GridSubset>(2);
        grids.put(this.gridSetBroker.WORLD_EPSG4326.getName(), GridSubsetFactory.createGridSubSet(this.gridSetBroker.WORLD_EPSG4326, bounds4326, 0, 30));
        grids.put(this.gridSetBroker.WORLD_EPSG3857.getName(), GridSubsetFactory.createGridSubSet(this.gridSetBroker.WORLD_EPSG3857, bounds3785, 0, 30));
        if (additionalBounds != null && additionalBounds.size() > 0) {
            for (CRSEnvelope env : additionalBounds.values()) {
                SRS srs = null;
                if (env.getEPSGCode() != null) {
                    srs = SRS.getSRS(env.getEPSGCode());
                }
                if (srs == null) {
                    log.error((Object)(env.toString() + " has no EPSG code"));
                    continue;
                }
                if (srs.getNumber() == 4326 || srs.getNumber() == 900913 || srs.getNumber() == 3857) {
                    log.debug((Object)("Skipping " + srs.toString() + " for " + name));
                    continue;
                }
                String gridSetName = name + ":" + srs.toString();
                BoundingBox extent = new BoundingBox(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
                GridSet gridSet = GridSetFactory.createGridSet(gridSetName, srs, extent, false, 25, null, 2.8E-4, 256, 256);
                grids.put(gridSetName, GridSubsetFactory.createGridSubSet(gridSet));
            }
        }
        ArrayList<String> mimeFormats = null;
        if (this.mimeTypes != null) {
            String[] mimeFormatArray = this.mimeTypes.split(",");
            mimeFormats = new ArrayList(mimeFormatArray.length);
            for (int i = 0; i < mimeFormatArray.length; ++i) {
                mimeFormats.add(mimeFormatArray[i]);
            }
        } else {
            mimeFormats = new ArrayList<String>(3);
            mimeFormats.add("image/png");
            mimeFormats.add("image/png8");
            mimeFormats.add("image/jpeg");
        }
        String[] metaStrings = this.metaTiling.split("x");
        int[] metaWidthHeight = new int[]{Integer.parseInt(metaStrings[0]), Integer.parseInt(metaStrings[1])};
        return new WMSLayer(name, wmsurl, stylesStr, name, mimeFormats, grids, metaWidthHeight, this.vendorParameters, queryable);
    }

    private WebMapServer getWMS() {
        try {
            return new WebMapServer(new URL(this.url));
        }
        catch (IOException ioe) {
            log.error((Object)(this.url + " -> " + ioe.getMessage()));
        }
        catch (ServiceException se) {
            log.error((Object)se.getMessage());
        }
        return null;
    }

    private String parseVersion(String url) {
        String tmp = url.toLowerCase();
        int start = tmp.indexOf("version=");
        if (start == -1) {
            return null;
        }
        int stop = tmp.indexOf("&", start += "version=".length());
        if (stop > 0) {
            return tmp.substring(start, stop);
        }
        return tmp.substring(start);
    }

    private double longToSphericalMercatorX(double x) {
        return x / 180.0 * 2.003750834E7;
    }

    private double latToSphericalMercatorY(double y) {
        if (y > 85.05112) {
            y = 85.05112;
        }
        if (y < -85.05112) {
            y = -85.05112;
        }
        y = Math.PI / 180 * y;
        double tmp = 0.7853981633974483 + y / 2.0;
        return 2.003750834E7 * Math.log(Math.tan(tmp)) / Math.PI;
    }
}

