/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.storage.StorageBroker;

public class SeedTask
extends GWCTask {
    private static Log log = LogFactory.getLog(SeedTask.class);
    private final SeedRequest req;
    private final TileLayer tl;
    private boolean reseed = false;
    private StorageBroker storageBroker;

    public SeedTask(StorageBroker sb, SeedRequest req, TileLayer tl, boolean reseed) {
        this.storageBroker = sb;
        this.req = req;
        this.tl = tl;
        this.reseed = reseed;
        this.type = reseed ? 1 : 0;
        this.layerName = tl.getName();
    }

    public void doAction() throws GeoWebCacheException {
        Thread.currentThread().setPriority(3);
        long START_TIME = System.currentTimeMillis();
        log.info((Object)("Thread " + this.threadOffset + " begins seeding layer : " + this.tl.getName()));
        int zoomStart = this.req.getZoomStart();
        int zoomStop = this.req.getZoomStop();
        MimeType mimeType = null;
        String format = this.req.getMimeFormat();
        if (format == null) {
            mimeType = this.tl.getMimeTypes().get(0);
        } else {
            try {
                mimeType = MimeType.createFromFormat(format);
            }
            catch (MimeException e4) {
                e4.printStackTrace();
            }
        }
        String gridSetId = this.req.getGridSetId();
        if (gridSetId == null) {
            gridSetId = this.tl.getGridSubsetForSRS(this.req.getSRS()).getName();
        }
        if (gridSetId == null) {
            gridSetId = this.tl.getGridSubsets().entrySet().iterator().next().getKey();
        }
        GridSubset gridSubset = this.tl.getGridSubset(gridSetId);
        BoundingBox bounds = this.req.getBounds();
        long[][] coveredGridLevels = bounds == null ? gridSubset.getCoverages() : gridSubset.getCoverageIntersections(bounds);
        int[] metaTilingFactors = this.tl.getMetaTilingFactors();
        int arrayIndex = this.getCurrentThreadArrayIndex();
        long TOTAL_TILES = -1L;
        this.tilesTotal = -1L;
        TOTAL_TILES = this.tileCount(coveredGridLevels, zoomStart, zoomStop);
        if (TOTAL_TILES > 0L) {
            this.tilesTotal = TOTAL_TILES / (long)this.threadCount;
        }
        int count = 0;
        boolean tryCache = !this.reseed;
        for (int level = zoomStart; level <= zoomStop && !this.terminate; ++level) {
            long starty;
            long[] levelGrid = coveredGridLevels[level];
            for (long gridy = starty = levelGrid[1] - levelGrid[1] % (long)metaTilingFactors[1]; gridy <= levelGrid[3]; gridy += (long)metaTilingFactors[1]) {
                long startx = levelGrid[0] - levelGrid[0] % (long)metaTilingFactors[0];
                for (long gridx = startx + (long)(this.threadOffset * metaTilingFactors[0]); gridx <= levelGrid[2] && !this.terminate; gridx += (long)(metaTilingFactors[0] * this.threadCount)) {
                    long[] gridLoc = new long[]{gridx, gridy, level};
                    ConveyorTile tile = new ConveyorTile(this.storageBroker, this.tl.getName(), gridSetId, gridLoc, mimeType, null, null, null, null);
                    try {
                        this.tl.seedTile(tile, tryCache);
                    }
                    catch (IOException ioe) {
                        log.error((Object)("Seed failed at " + tile.toString()));
                        throw new GeoWebCacheException(ioe.getMessage());
                    }
                    catch (GeoWebCacheException gwce) {
                        log.error((Object)("Seed failed at " + tile.toString()));
                        throw gwce;
                    }
                    long countX = gridx + (long)metaTilingFactors[0] - 1L > levelGrid[2] ? gridx + (long)metaTilingFactors[0] - 1L - levelGrid[2] : (long)metaTilingFactors[0];
                    long countY = gridy + (long)metaTilingFactors[1] - 1L > levelGrid[3] ? gridy + (long)metaTilingFactors[1] - 1L - levelGrid[3] : (long)metaTilingFactors[1];
                    count = (int)((long)count + countX * countY);
                    this.updateStatusInfo(arrayIndex, this.tl, count, START_TIME);
                }
            }
            double percCompl = 100.0 * (double)count / (double)this.tilesTotal;
            int intPercCompl = (int)Math.floor(percCompl);
            int decPercCompl = (int)Math.round((percCompl - (double)intPercCompl) * 100.0);
            if (intPercCompl < 0) {
                intPercCompl = 0;
                decPercCompl = 0;
            }
            log.info((Object)("Thread " + this.threadOffset + " completed (re)seeding level " + level + " for layer " + this.tl.getName() + " (ca. " + intPercCompl + "." + decPercCompl + "%)"));
        }
        if (this.terminate) {
            log.info((Object)("Thread " + this.threadOffset + " was terminated after " + this.tilesDone + " tiles"));
        } else {
            log.info((Object)("Thread " + this.threadOffset + " completed (re)seeding layer " + this.tl.getName() + " after " + this.tilesDone + " tiles, of an estimated " + this.tilesTotal));
        }
        if (this.threadOffset == 0) {
            this.runFilterUpdates(gridSetId);
        }
    }

    private long tileCount(long[][] coveredGridLevels, int startZoom, int stopZoom) {
        long count = 0L;
        for (int i = startZoom; i <= stopZoom; ++i) {
            long[] gridBounds = coveredGridLevels[i];
            long thisLevel = (1L + gridBounds[2] - gridBounds[0]) * (1L + gridBounds[3] - gridBounds[1]);
            if (thisLevel > 0x1FFFFFFFFFFFFFFFL && i != stopZoom) {
                return -1L;
            }
            count += thisLevel;
        }
        return count;
    }

    private int getCurrentThreadArrayIndex() {
        String tn = Thread.currentThread().getName();
        int indexOfnumber = tn.indexOf(100) + 2;
        String tmp = tn.substring(indexOfnumber);
        return Integer.parseInt(tmp) - 1;
    }

    private void updateStatusInfo(int arrayIndex, TileLayer layer, int tilesCount, long start_time) {
        this.tilesDone = tilesCount;
        this.timeSpent = (int)(System.currentTimeMillis() - start_time) / 1000;
        long timeTotal = Math.round((double)this.timeSpent * ((double)this.tilesTotal / (double)tilesCount));
        this.timeRemaining = (int)(timeTotal - this.timeSpent);
    }

    private void runFilterUpdates(String gridSetId) {
        List<RequestFilter> reqFilters;
        if ((this.req.getFilterUpdate() == null || this.req.getFilterUpdate().booleanValue()) && (reqFilters = this.tl.getRequestFilters()) != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, gridSetId)) {
                    log.info((Object)("Updated request filter " + reqFilter.getName()));
                    continue;
                }
                log.debug((Object)("Request filter " + reqFilter.getName() + " returned false on update."));
            }
        }
    }
}

