/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.MetaStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRangeObject;
import org.geowebcache.storage.WFSObject;

public class StorageBroker {
    private static Log log = LogFactory.getLog(StorageBroker.class);
    private BlobStore blobStore;
    private MetaStore metaStore;
    private boolean metaStoreEnabled = true;
    private boolean verifyFileSize = false;
    private boolean isReady = false;

    public StorageBroker(MetaStore metaStore, BlobStore blobStore) {
        this.metaStore = metaStore;
        this.blobStore = blobStore;
        this.metaStoreEnabled = metaStore != null ? metaStore.enabled() : false;
    }

    public void setVerifyFileSize(boolean verifyFileSize) {
        this.verifyFileSize = verifyFileSize;
    }

    public boolean delete(String layerName) throws StorageException {
        boolean ret = true;
        if (this.metaStoreEnabled) {
            ret = this.metaStore.delete(layerName);
        }
        return ret && this.blobStore.delete(layerName);
    }

    public boolean delete(TileRangeObject trObj) throws StorageException {
        if (this.metaStoreEnabled) {
            return this.metaStore.delete(this.blobStore, trObj);
        }
        return this.blobStore.delete(trObj);
    }

    public boolean expire(TileRangeObject trObj) throws StorageException {
        if (this.metaStoreEnabled) {
            return this.metaStore.expire(trObj);
        }
        return false;
    }

    public boolean get(TileObject tileObj) throws StorageException {
        if (!this.metaStoreEnabled) {
            return this.getBlobOnly(tileObj);
        }
        if (!this.metaStore.get(tileObj)) {
            return false;
        }
        if (tileObj.getId() == -1L) {
            throw new StorageException("metaStore.get() returned true, but did not set an id on the object");
        }
        if (tileObj.blob_size > 0) {
            byte[] blob = this.blobStore.get(tileObj);
            if (blob == null) {
                throw new StorageException("Blob for " + Arrays.toString(tileObj.xyz) + " was expected to have size " + tileObj.blob_size + " but was null.");
            }
            if (this.verifyFileSize && blob.length != tileObj.blob_size) {
                throw new StorageException("Blob was expected to have size " + tileObj.blob_size + " but was " + blob.length);
            }
            tileObj.blob = blob;
        }
        return true;
    }

    private boolean getBlobOnly(TileObject tileObj) throws StorageException {
        if (tileObj.getParameters() == null || tileObj.getParameters().length() == 0) {
            byte[] blob = this.blobStore.get(tileObj);
            if (blob == null) {
                return false;
            }
            tileObj.blob = blob;
            return true;
        }
        log.error((Object)"Cannot fetch tile with parameters if metastore is disabled!");
        return false;
    }

    public boolean get(WFSObject wfsObj) throws StorageException {
        if (!this.metaStore.get(wfsObj)) {
            log.error((Object)"Cannot use WFS objects if metastore is disabled!");
            return false;
        }
        if (wfsObj.getId() == -1L) {
            throw new StorageException("metaStore.get() returned true, but did not set an id on the object");
        }
        if (this.blobStore.get(wfsObj) == 0L) {
            throw new StorageException("The blob for WFS " + Long.toString(wfsObj.getId()) + " was of size 0");
        }
        return true;
    }

    public boolean put(TileObject tileObj) {
        if (!this.metaStoreEnabled) {
            return this.putBlobOnly(tileObj);
        }
        try {
            this.metaStore.put(tileObj);
            this.blobStore.put(tileObj);
            this.metaStore.unlock(tileObj);
            return true;
        }
        catch (StorageException se) {
            log.error((Object)se.getMessage());
            return false;
        }
    }

    private boolean putBlobOnly(TileObject tileObj) {
        if (tileObj.getParameters() == null || tileObj.getParameters().length() == 0) {
            try {
                this.blobStore.put(tileObj);
            }
            catch (StorageException se) {
                log.error((Object)("Unable to save tile: " + se.getMessage()));
                return false;
            }
            return true;
        }
        log.debug((Object)"Cannot save tile with parameters if metastore is disabled!");
        return false;
    }

    public boolean put(WFSObject wfsObj) {
        if (!this.metaStoreEnabled) {
            log.debug((Object)"Cannot use WFS objects if metastore is disabled!");
            return false;
        }
        try {
            this.metaStore.put(wfsObj);
            this.blobStore.put(wfsObj);
            this.metaStore.unlock(wfsObj);
            return true;
        }
        catch (StorageException se) {
            log.error((Object)se.getMessage());
            return false;
        }
    }

    public void destroy() {
        log.info((Object)"Destroying StorageBroker");
    }
}

