/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.metastore.jdbc.JDBCMBWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCMBIdCache {
    private static Log log = LogFactory.getLog(JDBCMBIdCache.class);
    public static int MAX_FORMATS = 50;
    public static int MAX_LAYERS = 100;
    public static int MAX_PARAMETERS = 100;
    public static int MAX_GRIDSETS = 50;
    private final Map<String, Long> formatsCache = new HashMap<String, Long>();
    private final Map<String, Long> layersCache = new HashMap<String, Long>();
    private final Map<String, Long> parametersCache = new HashMap<String, Long>();
    private final Map<String, Long> gridSetsCache = new HashMap<String, Long>();
    private final JDBCMBWrapper wrpr;

    protected JDBCMBIdCache(JDBCMBWrapper wrpr) {
        this.wrpr = wrpr;
    }

    private Long getOrInsert(String key, Map<String, Long> map, int maxSize, String table) throws StorageException {
        if (key.length() > 254) {
            throw new StorageException("Value is too big for table " + table + ":" + key);
        }
        Long res = null;
        try {
            res = this.doSelect(table, key);
            if (res == null) {
                res = this.doInsert(table, key);
            }
        }
        catch (SQLException se) {
            log.error((Object)("Error on Select or Insert: " + se.getMessage()));
        }
        if (res != null) {
            if (map.size() > maxSize) {
                map.clear();
            }
            map.put(key, res);
        }
        return res;
    }

    private Long doInsert(String table, String key) {
        Long res = null;
        try {
            String query = "INSERT INTO " + table + " (value) VALUES (?)";
            PreparedStatement prep = this.wrpr.getConnection().prepareStatement(query, 1);
            prep.setString(1, key);
            prep.executeUpdate();
            ResultSet rs = null;
            rs = prep.getGeneratedKeys();
            rs.first();
            res = rs.getLong(1);
            rs.close();
            prep.close();
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long doSelect(String table, String key) throws SQLException {
        Statement prep = null;
        ResultSet rs = null;
        try {
            String query = "SELECT ID FROM " + table + " WHERE VALUE LIKE ? LIMIT 1";
            prep = this.wrpr.getConnection().prepareStatement(query);
            prep.setString(1, key);
            rs = prep.executeQuery();
            if (rs.first()) {
                Long l = rs.getLong(1);
                return l;
            }
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage());
        }
        finally {
            if (prep != null) {
                prep.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getFormatId(String format) throws StorageException {
        Map<String, Long> map = this.formatsCache;
        synchronized (map) {
            Long ret = this.formatsCache.get(format);
            if (ret == null) {
                ret = this.getOrInsert(format, this.formatsCache, MAX_FORMATS, "FORMATS");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getLayerId(String layer) throws StorageException {
        Map<String, Long> map = this.layersCache;
        synchronized (map) {
            Long ret = this.layersCache.get(layer);
            if (ret == null) {
                ret = this.getOrInsert(layer, this.layersCache, MAX_LAYERS, "LAYERS");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getParametersId(String parameters) throws StorageException {
        Map<String, Long> map = this.parametersCache;
        synchronized (map) {
            Long ret = this.parametersCache.get(parameters);
            if (ret == null) {
                ret = this.getOrInsert(parameters, this.parametersCache, MAX_PARAMETERS, "PARAMETERS");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getGridSetsId(String gridSetId) throws StorageException {
        Map<String, Long> map = this.gridSetsCache;
        synchronized (map) {
            Long ret = this.gridSetsCache.get(gridSetId);
            if (ret == null) {
                ret = this.getOrInsert(gridSetId, this.gridSetsCache, MAX_GRIDSETS, "GRIDSETS");
            }
            return ret;
        }
    }
}

