/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class ApplicationContextProvider
implements ApplicationContextAware {
    private static Log log = LogFactory.getLog(ApplicationContextProvider.class);
    WebApplicationContext ctx;

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = (WebApplicationContext)arg0;
    }

    public WebApplicationContext getApplicationContext() {
        return this.ctx;
    }

    public String getSystemVar(String varName, String defaultValue) {
        if (this.ctx == null) {
            String msg = "Application context was not set yet! Damn you Spring Framework :( ";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        String tmpVar = this.ctx.getServletContext().getInitParameter(varName);
        if (tmpVar != null && tmpVar.length() > 7) {
            log.info((Object)("Using servlet init context parameter to configure " + varName + " to " + tmpVar));
            return tmpVar;
        }
        tmpVar = System.getProperty(varName);
        if (tmpVar != null && tmpVar.length() > 7) {
            log.info((Object)("Using Java environment variable to configure " + varName + " to " + tmpVar));
            return tmpVar;
        }
        tmpVar = System.getenv(varName);
        if (tmpVar != null && tmpVar.length() > 7) {
            log.info((Object)("Using System environment variable to configure " + varName + " to " + tmpVar));
            return tmpVar;
        }
        log.info((Object)("No context parameter, system or Java environment variables found for " + varName));
        log.info((Object)("Reverting to " + defaultValue));
        return defaultValue;
    }
}

