/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.function.GeometryTransformation;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class FilterFunction_isometric
extends FunctionExpressionImpl
implements FunctionExpression,
GeometryTransformation {
    public FilterFunction_isometric() {
        super("isometric");
    }

    public int getArgCount() {
        return 2;
    }

    public Object evaluate(Object feature) {
        Geometry geom = (Geometry)this.getExpression(0).evaluate(feature, Geometry.class);
        Double extrusion = (Double)this.getExpression(1).evaluate(feature, Double.class);
        if (geom != null && extrusion != null) {
            SegmentExtractorFilter extractor = new SegmentExtractorFilter();
            geom.apply(extractor);
            List<Polygon> faces = extractor.getFaces(geom.getFactory(), extrusion);
            Polygon[] polyArray = faces.toArray(new Polygon[faces.size()]);
            return geom.getFactory().createMultiPolygon(polyArray);
        }
        return null;
    }

    public ReferencedEnvelope invert(ReferencedEnvelope renderingEnvelope) {
        Double offsetX = (Double)this.getExpression(1).evaluate(null, Double.class);
        Double offsetY = (Double)this.getExpression(2).evaluate(null, Double.class);
        if (offsetX != null && offsetY != null) {
            ReferencedEnvelope offseted = new ReferencedEnvelope(renderingEnvelope);
            offseted.translate(offsetX, offsetY);
            return offseted;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Segment
    implements Comparable<Segment> {
        double x0;
        double y0;
        double x1;
        double y1;

        public Segment(double x0, double y0, double x1, double y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        @Override
        public int compareTo(Segment other) {
            double otherMaxX;
            double otherMaxY;
            double maxY = Math.max(this.y0, this.y1);
            if (maxY > (otherMaxY = Math.max(other.y0, other.y1))) {
                return -1;
            }
            if (maxY < otherMaxY) {
                return 1;
            }
            double maxX = Math.max(this.x0, this.x1);
            if (maxX > (otherMaxX = Math.max(other.x0, other.x1))) {
                return 1;
            }
            if (maxX < otherMaxX) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SegmentExtractorFilter
    implements GeometryComponentFilter {
        List<Segment> segments = new ArrayList<Segment>();

        SegmentExtractorFilter() {
        }

        @Override
        public void filter(Geometry geom) {
            if (geom instanceof LineString) {
                this.extractSegments(((LineString)geom).getCoordinateSequence());
            }
        }

        private void extractSegments(CoordinateSequence cs) {
            for (int i = 0; i < cs.size() - 1; ++i) {
                this.segments.add(new Segment(cs.getX(i), cs.getY(i), cs.getX(i + 1), cs.getY(i + 1)));
            }
        }

        List<Polygon> getFaces(GeometryFactory gf, double extrude) {
            Collections.sort(this.segments);
            ArrayList<Polygon> result = new ArrayList<Polygon>();
            for (Segment segment : this.segments) {
                CoordinateSequence cs = gf.getCoordinateSequenceFactory().create(5, 2);
                cs.setOrdinate(0, 0, segment.x0);
                cs.setOrdinate(0, 1, segment.y0);
                cs.setOrdinate(3, 0, segment.x0);
                cs.setOrdinate(3, 1, segment.y0 + extrude);
                cs.setOrdinate(2, 0, segment.x1);
                cs.setOrdinate(2, 1, segment.y1 + extrude);
                cs.setOrdinate(1, 0, segment.x1);
                cs.setOrdinate(1, 1, segment.y1);
                cs.setOrdinate(4, 0, segment.x0);
                cs.setOrdinate(4, 1, segment.y0);
                result.add(gf.createPolygon(gf.createLinearRing(cs), null));
            }
            return result;
        }
    }
}

