/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.geowebcache.georss.GeoRSSReader;
import org.geowebcache.georss.StaxGeoRSSReader;

class GeoRSSReaderFactory {
    GeoRSSReaderFactory() {
    }

    public GeoRSSReader createReader(URL feedUrl) throws IOException {
        URLConnection conn = feedUrl.openConnection();
        String contentEncoding = conn.getContentEncoding();
        if (contentEncoding == null) {
            contentEncoding = "UTF-8";
        }
        InputStream in = conn.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, contentEncoding));
        return this.createReader(reader);
    }

    public GeoRSSReader createReader(Reader feed) throws IOException {
        StaxGeoRSSReader reader;
        try {
            reader = new StaxGeoRSSReader(feed);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
        return reader;
    }
}

