/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridCoverage;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.grid.TileDimensionsMismatchException;
import org.geowebcache.util.ServletUtils;

public class GridSubset {
    protected int firstLevel = 0;
    protected GridSet gridSet;
    protected GridCoverage[] gridCoverageLevels;
    protected boolean fullGridSetCoverage = false;
    protected BoundingBox originalExtent = null;

    protected GridSubset(GridSet gridSet) {
        this.gridSet = gridSet;
    }

    public BoundingBox boundsFromIndex(long[] tileIndex) {
        return this.gridSet.boundsFromIndex(tileIndex);
    }

    public BoundingBox boundsFromRectangle(long[] rectangleExtent) {
        return this.gridSet.boundsFromRectangle(rectangleExtent);
    }

    public long[] closestIndex(BoundingBox tileBounds) throws GridMismatchException {
        return this.gridSet.closestIndex(tileBounds);
    }

    public long[] closestRectangle(BoundingBox rectangleBounds) {
        return this.gridSet.closestRectangle(rectangleBounds);
    }

    public void checkCoverage(long[] index) throws OutsideCoverageException {
        if (index[2] >= (long)this.firstLevel && index[2] < (long)this.gridCoverageLevels.length) {
            long[] coverage = this.gridCoverageLevels[(int)index[2]].coverage;
            if (index[0] >= coverage[0] && index[0] <= coverage[2] && index[1] >= coverage[1] && index[1] <= coverage[3]) {
                return;
            }
            throw new OutsideCoverageException(index, coverage);
        }
        throw new OutsideCoverageException(index, this.firstLevel, this.gridCoverageLevels.length - 1);
    }

    public void checkTileDimensions(int width, int height) throws TileDimensionsMismatchException {
        if (width != this.gridSet.tileWidth || height != this.gridSet.tileHeight) {
            throw new TileDimensionsMismatchException(width, height, this.gridSet.tileWidth, this.gridSet.tileWidth);
        }
    }

    public long[][] expandToMetaFactors(long[][] coverages, int[] metaFactors) {
        long[][] ret = ServletUtils.arrayDeepCopy(coverages);
        for (int z = 0; z < ret.length; ++z) {
            long[] cov = ret[z];
            cov[0] = cov[0] - cov[0] % (long)metaFactors[0];
            cov[1] = cov[1] - cov[1] % (long)metaFactors[1];
            cov[2] = cov[2] - cov[2] % (long)metaFactors[0] + (long)(metaFactors[0] - 1);
            if (cov[2] > this.gridSet.gridLevels[z].extent[0]) {
                cov[2] = this.gridSet.gridLevels[z].extent[0];
            }
            cov[3] = cov[3] - cov[3] % (long)metaFactors[1] + (long)(metaFactors[1] - 1);
            if (cov[3] <= this.gridSet.gridLevels[z].extent[1]) continue;
            cov[3] = this.gridSet.gridLevels[z].extent[1];
        }
        return ret;
    }

    public long[] getCoverage(int level) {
        return this.gridCoverageLevels[this.firstLevel + level].coverage;
    }

    public long[][] getCoverages() {
        long[][] ret = new long[this.gridCoverageLevels.length][5];
        for (int i = 0; i < ret.length; ++i) {
            long[] cov = this.gridCoverageLevels[i].coverage;
            long[] cur = new long[]{cov[0], cov[1], cov[2], cov[3], this.firstLevel + i};
            ret[i] = cur;
        }
        return ret;
    }

    public double getDotsPerInch() {
        return 0.0254 / this.gridSet.pixelSize;
    }

    public BoundingBox getCoverageBounds(int level) {
        long[] coverage = this.gridCoverageLevels[this.firstLevel + level].coverage;
        return this.gridSet.boundsFromRectangle(coverage);
    }

    public long[] getCoverageBestFit() {
        int i;
        long[] cov = null;
        for (i = this.gridCoverageLevels.length - 1; i > 0 && ((cov = this.gridCoverageLevels[i].coverage)[0] != cov[2] || cov[1] != cov[3]); --i) {
        }
        cov = this.gridCoverageLevels[i].coverage;
        long[] ret = new long[]{cov[0], cov[1], cov[2], cov[3], i + this.firstLevel};
        return ret;
    }

    public BoundingBox getCoverageBestFitBounds() {
        return this.boundsFromRectangle(this.getCoverageBestFit());
    }

    public long[] getCoverageIntersection(long[] reqRectangle) {
        GridCoverage gridCov = this.gridCoverageLevels[this.firstLevel + (int)reqRectangle[4]];
        return gridCov.getIntersection(reqRectangle);
    }

    public long[][] getCoverageIntersections(BoundingBox reqBounds) {
        long[][] ret = new long[this.gridCoverageLevels.length][5];
        for (int i = 0; i < this.gridCoverageLevels.length; ++i) {
            long[] reqRectangle = this.gridSet.closestRectangle(i + this.firstLevel, reqBounds);
            ret[i] = this.gridCoverageLevels[i].getIntersection(reqRectangle);
        }
        return ret;
    }

    public long[] getCoverageIntersection(int level, BoundingBox reqBounds) {
        long[] reqRectangle = this.gridSet.closestRectangle(level, reqBounds);
        return this.gridCoverageLevels[level].getIntersection(reqRectangle);
    }

    public long getGridIndex(String gridId) {
        for (int i = 0; i < this.gridCoverageLevels.length; ++i) {
            if (!this.gridSet.gridLevels[this.firstLevel + i].name.equals(gridId)) continue;
            return i;
        }
        return -1L;
    }

    public String[] getGridNames() {
        String[] ret = new String[this.gridCoverageLevels.length];
        for (int i = 0; i < this.gridCoverageLevels.length; ++i) {
            ret[i] = this.gridSet.gridLevels[i + this.firstLevel].name;
        }
        return ret;
    }

    public GridSet getGridSet() {
        return this.gridSet;
    }

    public BoundingBox getGridSetBounds() {
        return this.gridSet.getBounds();
    }

    public long[] getGridSetExtent(int z) {
        return this.gridSet.gridLevels[z].extent;
    }

    public String getName() {
        return this.gridSet.name;
    }

    public BoundingBox getOriginalExtent() {
        if (this.originalExtent == null) {
            return this.gridSet.originalExtent;
        }
        return this.originalExtent;
    }

    public double[] getResolutions() {
        double[] ret = new double[this.firstLevel + this.gridCoverageLevels.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.gridSet.gridLevels[i].resolution;
        }
        return ret;
    }

    public long[][] getSubGrid(long[] gridLoc) throws GeoWebCacheException {
        int idx = (int)gridLoc[2];
        long[][] ret = new long[][]{{-1L, -1L, -1L}, {-1L, -1L, -1L}, {-1L, -1L, -1L}, {-1L, -1L, -1L}};
        if (idx - this.firstLevel + 1 < this.gridCoverageLevels.length) {
            double resolutionCheck = this.gridSet.gridLevels[idx].resolution / 2.0 - this.gridSet.gridLevels[idx + 1].resolution;
            if (Math.abs(resolutionCheck) > this.gridSet.gridLevels[idx + 1].resolution * 0.025) {
                throw new GeoWebCacheException("The resolution is not decreasing by a factor of two for " + this.getName());
            }
            GridCoverage cov = this.gridCoverageLevels[idx + 1];
            long baseX = gridLoc[0] * 2L;
            long baseY = gridLoc[1] * 2L;
            long baseZ = idx + 1;
            long[] xOffset = new long[]{0L, 1L, 0L, 1L};
            long[] yOffset = new long[]{0L, 0L, 1L, 1L};
            for (int i = 0; i < 4; ++i) {
                if (baseX + xOffset[i] < cov.coverage[0] || baseX + xOffset[i] > cov.coverage[2] || baseY + yOffset[i] < cov.coverage[1] || baseY + yOffset[i] > cov.coverage[3]) continue;
                ret[i][0] = baseX + xOffset[i];
                ret[i][1] = baseY + yOffset[i];
                ret[i][2] = baseZ;
            }
        }
        return ret;
    }

    public boolean getScaleWarning() {
        return this.gridSet.scaleWarning;
    }

    public SRS getSRS() {
        return this.gridSet.srs;
    }

    public int getTileHeight() {
        return this.gridSet.tileHeight;
    }

    public int getTileWidth() {
        return this.gridSet.tileWidth;
    }

    public long[][] getWMTSCoverages() {
        long[][] ret = new long[this.gridCoverageLevels.length][4];
        for (int i = 0; i < this.gridCoverageLevels.length; ++i) {
            Grid grid = this.gridSet.gridLevels[i + this.firstLevel];
            GridCoverage gridCov = this.gridCoverageLevels[i];
            long[] cur = new long[]{gridCov.coverage[0], grid.extent[1] - gridCov.coverage[3], gridCov.coverage[2], grid.extent[1] - gridCov.coverage[1]};
            ret[i] = cur;
        }
        return ret;
    }

    public int getZoomStart() {
        return this.firstLevel;
    }

    public int getZoomStop() {
        return this.firstLevel + this.gridCoverageLevels.length - 1;
    }

    public boolean fullGridSetCoverage() {
        return this.fullGridSetCoverage;
    }
}

