/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.updatesource;

import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.rest.GWCTask;

public class GeoRSSFeedDefinition
extends UpdateSourceDefinition {
    private String feedUrl;
    private String gridSetId;
    private Integer pollInterval;
    private String operation;
    private String format;
    private Integer seedingThreads;
    private Integer maxMaskLevel;

    public int getMaxMaskLevel() {
        return this.maxMaskLevel == null ? 10 : this.maxMaskLevel;
    }

    void setMaxMaskLevel(int level) {
        this.maxMaskLevel = level;
    }

    public GWCTask.TYPE getOperation() {
        if (this.operation == null || this.operation.equalsIgnoreCase("truncate")) {
            return GWCTask.TYPE.TRUNCATE;
        }
        if (this.operation.equalsIgnoreCase("reseed")) {
            return GWCTask.TYPE.RESEED;
        }
        if (this.operation.equalsIgnoreCase("seed")) {
            return GWCTask.TYPE.SEED;
        }
        return GWCTask.TYPE.TRUNCATE;
    }

    public int getSeedingThreads() {
        return this.seedingThreads == null ? 1 : this.seedingThreads;
    }

    public String getFeedUrl() {
        return this.feedUrl;
    }

    public String getFormat() {
        return this.format;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public int getPollInterval() {
        if (this.pollInterval == null) {
            return -1;
        }
        return this.pollInterval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GeoRSS feed[");
        sb.append("gridSetId: ").append(this.gridSetId);
        sb.append(", poll interval: ").append(this.getPollIntervalStr());
        sb.append(", feed URL: '").append(this.feedUrl).append("'");
        sb.append(", operation: ").append(this.operation);
        sb.append(", seeding threads: ").append(this.seedingThreads);
        sb.append(", max masking level: ").append(this.maxMaskLevel);
        return sb.append("]").toString();
    }

    public String getPollIntervalStr() {
        return this.getPollIntervalStr(this.pollInterval);
    }

    private String getPollIntervalStr(Integer pollInterval) {
        String pollIntervalStr;
        if (pollInterval == null) {
            return "Disabled";
        }
        int MINUTE = 60;
        int HOUR = 3600;
        int DAY = 86400;
        int interval = pollInterval;
        if (interval > 86400) {
            int days = interval / 86400;
            int remaining = interval % 86400;
            pollIntervalStr = days + " Day" + (days > 1 ? "s, " : ", ");
            pollIntervalStr = pollIntervalStr + this.getPollIntervalStr(remaining);
        } else if (interval > 3600) {
            int hours = interval / 3600;
            int remaining = interval % 3600;
            pollIntervalStr = hours + " Hour" + (hours > 1 ? "s, " : ", ");
            pollIntervalStr = pollIntervalStr + this.getPollIntervalStr(remaining);
        } else if (interval > 60) {
            int minutes = interval / 60;
            int remaining = interval % 60;
            pollIntervalStr = minutes + " Minute" + (minutes > 1 ? "s, " : ", ");
            pollIntervalStr = pollIntervalStr + this.getPollIntervalStr(remaining);
        } else {
            pollIntervalStr = interval + " Second" + (interval > 1 ? "s" : "");
        }
        return pollIntervalStr;
    }
}

