/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest;

import org.geowebcache.GeoWebCacheException;

public abstract class GWCTask {
    protected int threadCount = 1;
    protected int threadOffset = 0;
    long taskId = -1L;
    protected TYPE type = TYPE.UNSET;
    protected STATE state = STATE.UNSET;
    protected String layerName = null;
    protected long timeSpent = -1L;
    protected long timeRemaining = -1L;
    protected long tilesDone = -1L;
    protected long tilesTotal = -1L;
    protected boolean terminate = false;

    public abstract void doAction() throws GeoWebCacheException;

    public void setThreadInfo(int threadCount, int threadOffset) {
        this.threadCount = threadCount;
        this.threadOffset = threadOffset;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getThreadOffset() {
        return this.threadOffset;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public long getTilesTotal() {
        return this.tilesTotal;
    }

    public String getTilesTotalStr() {
        if (this.tilesTotal > 0L) {
            return Long.toString(this.tilesTotal);
        }
        return "Too many to count";
    }

    public long getTilesDone() {
        return this.tilesDone;
    }

    public long getTimeRemaining() {
        if (this.tilesTotal > 0L) {
            return this.timeRemaining;
        }
        return -2L;
    }

    public void terminateNicely() {
        this.terminate = true;
    }

    public TYPE getType() {
        return this.type;
    }

    public STATE getState() {
        return this.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        UNSET,
        READY,
        RUNNING,
        DONE,
        DEAD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        UNSET,
        SEED,
        RESEED,
        TRUNCATE;

    }
}

