/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.filter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.util.Iterator;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.filter.XmlFilterUpdate;
import org.geowebcache.rest.filter.ZipFilterUpdate;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class FilterUpdateRestlet
extends GWCRestlet {
    private TileLayerDispatcher tld;

    public FilterUpdateRestlet(TileLayerDispatcher tld) {
        this.tld = tld;
    }

    public void handle(Request request, Response response) {
        Method met = request.getMethod();
        try {
            if (!met.equals((Object)Method.POST)) {
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            this.doPost(request, response);
        }
        catch (RestletException re) {
            response.setEntity(re.getRepresentation());
            response.setStatus(re.getStatus());
        }
        catch (IOException ioe) {
            response.setEntity("Encountered IO error " + ioe.getMessage(), MediaType.TEXT_PLAIN);
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
        }
    }

    public void doPost(Request req, Response resp) throws RestletException, IOException {
        String filterName = (String)req.getAttributes().get("filterName");
        String updateType = (String)req.getAttributes().get("updateType");
        Iterator<TileLayer> lIter = this.tld.getLayers().values().iterator();
        RequestFilter filter = null;
        TileLayer tl = null;
        while (lIter.hasNext() && filter == null) {
            tl = lIter.next();
            Iterator<RequestFilter> fIter = tl.getRequestFilters().iterator();
            while (fIter.hasNext() && filter == null) {
                RequestFilter cFilter = fIter.next();
                if (!cFilter.getName().equals(filterName)) continue;
                filter = cFilter;
            }
        }
        if (filter == null) {
            throw new RestletException("No filter by the name " + filterName + " was found.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (updateType.equalsIgnoreCase("xml")) {
            XStream xs = XMLConfiguration.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new DomDriver()));
            XmlFilterUpdate fu = (XmlFilterUpdate)xs.fromXML(req.getEntity().getStream());
            fu.runUpdate(filter, tl);
        } else if (updateType.equalsIgnoreCase("zip")) {
            ZipFilterUpdate fu = new ZipFilterUpdate(req.getEntity().getStream());
            fu.runUpdate(filter, tl);
        } else {
            throw new RestletException("Unknow update type " + updateType + "\n", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        resp.setEntity("Filter update completed, no problems encountered.\n", MediaType.TEXT_PLAIN);
        resp.setStatus(Status.SUCCESS_OK);
    }
}

