/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.seed.MTSeeder;
import org.geowebcache.rest.seed.SeedFormRestlet;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.rest.seed.SeedTask;
import org.geowebcache.rest.seed.SeederThreadPoolExecutor;
import org.geowebcache.rest.seed.TileRangeIterator;
import org.geowebcache.rest.seed.TruncateTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;

public class SeedRestlet
extends GWCRestlet {
    private static Log log = LogFactory.getLog(SeedFormRestlet.class);
    SeederThreadPoolExecutor threadPool;
    TileLayerDispatcher layerDispatcher;
    StorageBroker storageBroker;
    public JSONObject myrequest;

    public void handle(Request request, Response response) {
        block5: {
            Method met = request.getMethod();
            try {
                if (met.equals((Object)Method.GET)) {
                    this.doGet(request, response);
                    break block5;
                }
                if (met.equals((Object)Method.POST)) {
                    this.doPost(request, response);
                    break block5;
                }
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            catch (RestletException re) {
                response.setEntity(re.getRepresentation());
                response.setStatus(re.getStatus());
            }
            catch (IOException ioe) {
                response.setEntity("Encountered IO error " + ioe.getMessage(), MediaType.TEXT_PLAIN);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(Request req, Response resp) throws RestletException {
        JsonRepresentation rep = null;
        try {
            long[][] list;
            XStream xs = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
            JSONObject obj = null;
            long[][] lArray = list = this.getStatusList();
            synchronized (list) {
                obj = new JSONObject(xs.toXML((Object)list));
                // ** MonitorExit[var7_8] (shouldn't be in output)
                rep = new JsonRepresentation(obj);
            }
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
        {
            resp.setEntity(rep);
            return;
        }
    }

    public void doPost(Request req, Response resp) throws RestletException, IOException {
        String formatExtension = (String)req.getAttributes().get("extension");
        SeedRequest sr = null;
        XStream xs = XMLConfiguration.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new DomDriver()));
        if (formatExtension.equalsIgnoreCase("xml")) {
            sr = (SeedRequest)xs.fromXML(req.getEntity().getStream());
        } else if (formatExtension.equalsIgnoreCase("json")) {
            sr = (SeedRequest)xs.fromXML(this.convertJson(req.getEntity().getText()));
        } else {
            throw new RestletException("Format extension unknown or not specified: " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        TileLayer tl = SeedRestlet.findTileLayer(layerName, this.layerDispatcher);
        TileRange tr = SeedRestlet.createTileRange(sr, tl);
        GWCTask[] tasks = this.createTasks(tr, tl, sr.getType(), sr.getThreadCount(), sr.getFilterUpdate());
        this.dispatchTasks(tasks);
    }

    private String convertJson(String entityText) throws IOException {
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        StringReader reader = new StringReader(entityText);
        HierarchicalStreamReader hsr = driver.createReader((Reader)reader);
        StringWriter writer = new StringWriter();
        new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
        writer.close();
        return writer.toString();
    }

    public GWCTask[] createTasks(TileRange tr, TileLayer tl, GWCTask.TYPE type, int threadCount, boolean filterUpdate) throws RestletException {
        if (type == GWCTask.TYPE.TRUNCATE || threadCount < 1) {
            log.debug((Object)"Forcing thread count to 1");
            threadCount = 1;
        }
        if (threadCount > this.threadPool.getMaximumPoolSize()) {
            throw new RestletException("Asked to use " + threadCount + " threads," + " but maximum is " + this.threadPool.getMaximumPoolSize(), Status.SERVER_ERROR_INTERNAL);
        }
        TileRangeIterator trIter = new TileRangeIterator(tr, tl.getMetaTilingFactors());
        GWCTask[] tasks = new GWCTask[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            tasks[i] = this.createTask(type, trIter, tl, filterUpdate);
            tasks[i].setThreadInfo(threadCount, i);
        }
        return tasks;
    }

    public void dispatchTasks(GWCTask[] tasks) throws RestletException {
        for (int i = 0; i < tasks.length; ++i) {
            this.threadPool.submit(new MTSeeder(tasks[i]));
        }
    }

    protected static TileRange createTileRange(SeedRequest req, TileLayer tl) {
        int zoomStart = req.getZoomStart();
        int zoomStop = req.getZoomStop();
        MimeType mimeType = null;
        String format = req.getMimeFormat();
        if (format == null) {
            mimeType = tl.getMimeTypes().get(0);
        } else {
            try {
                mimeType = MimeType.createFromFormat(format);
            }
            catch (MimeException e4) {
                e4.printStackTrace();
            }
        }
        String gridSetId = req.getGridSetId();
        if (gridSetId == null) {
            gridSetId = tl.getGridSubsetForSRS(req.getSRS()).getName();
        }
        if (gridSetId == null) {
            gridSetId = tl.getGridSubsets().entrySet().iterator().next().getKey();
        }
        GridSubset gridSubset = tl.getGridSubset(gridSetId);
        BoundingBox bounds = req.getBounds();
        long[][] coveredGridLevels = bounds == null ? gridSubset.getCoverages() : gridSubset.getCoverageIntersections(bounds);
        int[] metaTilingFactors = tl.getMetaTilingFactors();
        coveredGridLevels = gridSubset.expandToMetaFactors(coveredGridLevels, metaTilingFactors);
        return new TileRange(tl.getName(), gridSetId, zoomStart, zoomStop, coveredGridLevels, mimeType, null);
    }

    private GWCTask createTask(GWCTask.TYPE type, TileRangeIterator trIter, TileLayer tl, boolean doFilterUpdate) throws RestletException {
        switch (type) {
            case SEED: {
                return new SeedTask(this.storageBroker, trIter, tl, false, doFilterUpdate);
            }
            case RESEED: {
                return new SeedTask(this.storageBroker, trIter, tl, true, doFilterUpdate);
            }
            case TRUNCATE: {
                return new TruncateTask(this.storageBroker, trIter.getTileRange(), tl, doFilterUpdate);
            }
        }
        throw new RestletException("Unknown request type " + (Object)((Object)type), Status.CLIENT_ERROR_BAD_REQUEST);
    }

    private long[][] getStatusList() {
        Iterator<Map.Entry<Long, GWCTask>> iter = this.threadPool.getRunningTasksIterator();
        long[][] ret = new long[this.threadPool.getMaximumPoolSize()][3];
        int idx = 0;
        while (iter.hasNext()) {
            Map.Entry<Long, GWCTask> entry = iter.next();
            GWCTask task = entry.getValue();
            ret[idx][0] = (int)task.getTilesDone();
            ret[idx][1] = (int)task.getTilesTotal();
            ret[idx][2] = task.getTimeRemaining();
            ++idx;
        }
        return ret;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }

    public void setThreadPoolExecutor(SeederThreadPoolExecutor stpe) {
        this.threadPool = stpe;
    }

    public void setStorageBroker(StorageBroker sb) {
        this.storageBroker = sb;
    }
}

