/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service;

public class OWSException
extends Exception {
    private static final long serialVersionUID = -8024005353689857211L;
    int httpCode;
    String exceptionCode;
    String locator;
    String exceptionText;

    public OWSException(int httpCode, String exceptionCode, String locator, String exceptionText) {
        this.httpCode = httpCode;
        this.exceptionCode = exceptionCode;
        this.locator = locator;
        this.exceptionText = exceptionText;
    }

    public int getResponseCode() {
        return this.httpCode;
    }

    public String getContentType() {
        return "text/xml";
    }

    public byte[] getResponse() {
        return this.toString().getBytes();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        str.append("<ExceptionReport version=\"1.1.0\" xmlns=\"http://www.opengis.net/ows/1.1\"\n");
        str.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        str.append("  xsi:schemaLocation=\"http://www.opengis.net/ows/1.1 http://geowebcache.org/schema/ows/1.1.0/owsExceptionReport.xsd\">\n");
        str.append("  <Exception exceptionCode=\"" + this.exceptionCode + "\" locator=\"" + this.locator + "\">\n");
        str.append("    <ExceptionText>" + this.exceptionText + "</ExceptionText>\n");
        str.append("  </Exception>\n");
        str.append("</ExceptionReport>\n");
        return str.toString();
    }
}

