/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorWFS;
import org.geowebcache.service.Service;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.ServletUtils;

public class WFSService
extends Service {
    public static final String SERVICE_WFS = "wfs";
    public static final String GEOSERVER_WFS_URL = "GEOSERVER_WFS_URL";
    public static final String GEOWEBCACHE_WFS_FILTER = "GEOWEBCACHE_WFS_FILTER";
    private static Log log = LogFactory.getLog(WFSService.class);
    private int readTimeout;
    private String urlString;
    private String regexFilter;
    private StorageBroker storageBroker;

    public WFSService(StorageBroker sb, String urlString, String regexFilter, int readTimeout) {
        super(SERVICE_WFS);
        this.urlString = urlString;
        this.storageBroker = sb;
        this.regexFilter = regexFilter != null && regexFilter.length() == 0 ? null : regexFilter;
        readTimeout = 1000 * readTimeout;
        log.info((Object)("Configured to forward to " + urlString + " , timeout is " + readTimeout + "ms regex filter " + regexFilter));
    }

    public WFSService(StorageBroker sb, ApplicationContextProvider ctxProv, String regexFilter, int readTimeout) {
        super(SERVICE_WFS);
        this.storageBroker = sb;
        this.urlString = ctxProv.getSystemVar(GEOSERVER_WFS_URL, null);
        if (this.urlString != null) {
            if (this.urlString.contains("?")) {
                this.urlString = this.urlString.substring(0, this.urlString.indexOf("?"));
            }
        } else {
            this.urlString = "http://localhost:8080/geoserver/wfs";
        }
        if (ctxProv.getSystemVar(GEOWEBCACHE_WFS_FILTER, null) != null) {
            regexFilter = ctxProv.getSystemVar(GEOWEBCACHE_WFS_FILTER, null);
        }
        readTimeout = 1000 * readTimeout;
        log.info((Object)("Configured to forward to " + this.urlString + " , timeout is " + readTimeout + "ms, regex filter " + regexFilter));
    }

    public ConveyorWFS getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        String parameters = null;
        byte[] queryBlob = null;
        if (request.getContentLength() > 0) {
            try {
                queryBlob = ServletUtils.readStream((InputStream)request.getInputStream(), 2048, 1024);
            }
            catch (IOException ioe) {
                throw new GeoWebCacheException("Unable to get WFS query blob: " + ioe.getMessage());
            }
            this.performRegexCheck(queryBlob);
        } else {
            parameters = request.getQueryString();
            this.performRegexCheck(parameters);
        }
        ConveyorWFS conv = new ConveyorWFS(this.storageBroker, parameters, queryBlob, request, response);
        return conv;
    }

    private void performRegexCheck(byte[] queryBlob) throws GeoWebCacheException {
        if (this.regexFilter == null) {
            return;
        }
        if (queryBlob.length > 102400) {
            throw new GeoWebCacheException("Queryblob is too large (" + queryBlob.length + ") to apply filter.");
        }
        this.performRegexCheck(new String(queryBlob));
    }

    private void performRegexCheck(String parameters) throws GeoWebCacheException {
        if (this.regexFilter == null) {
            return;
        }
        if (!parameters.matches(this.regexFilter)) {
            throw new GeoWebCacheException("Sorry. The request violates the filter.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Conveyor genConv) throws GeoWebCacheException {
        ConveyorWFS conv = (ConveyorWFS)genConv;
        try {
            if (!conv.retrieve(-1)) {
                WFSService wFSService = this;
                synchronized (wFSService) {
                    if (!conv.retrieve(-1)) {
                        this.forwardRequest(conv);
                        conv.persist();
                    }
                }
            }
            Service.writeWFSResponse(conv, false);
        }
        finally {
            InputStream is = conv.getInputStream();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new GeoWebCacheException(e.getMessage());
                }
            }
        }
    }

    private void forwardRequest(ConveyorWFS conv) throws GeoWebCacheException {
        HttpURLConnection conxn = null;
        try {
            if (conv.getQueryBlob() == null) {
                URL conxnUrl = new URL(this.urlString + "?" + conv.servletReq.getQueryString());
                conxn = (HttpURLConnection)conxnUrl.openConnection();
                conxn.setConnectTimeout(5000);
                conxn.setReadTimeout(this.readTimeout);
            } else {
                URL conxnUrl = new URL(this.urlString);
                conxn = (HttpURLConnection)conxnUrl.openConnection();
                conxn.setDoOutput(true);
                conxn.setConnectTimeout(5000);
                conxn.setReadTimeout(this.readTimeout);
                conxn.setRequestMethod(conv.servletReq.getMethod());
                if (conv.servletReq.getContentType() != null) {
                    conxn.setRequestProperty("Content-Type", conv.servletReq.getContentType());
                }
            }
            this.connectAndLoad(conxn, conv);
        }
        catch (MalformedURLException mue) {
            throw new GeoWebCacheException("Unable to connect to WFS backend: " + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new GeoWebCacheException("Unable to communicate with WFS backend " + ioe.getMessage());
        }
    }

    private void connectAndLoad(HttpURLConnection conxn, ConveyorWFS conv) throws IOException, GeoWebCacheException {
        conxn.connect();
        if (200 != conxn.getResponseCode()) {
            throw new GeoWebCacheException("Got responsecode " + conxn.getResponseCode() + " from " + conxn.getURL());
        }
        String contentType = conxn.getContentType();
        conv.setInputStream(conxn.getInputStream());
        conv.setMimeTypeString(contentType);
    }
}

