/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.service.wms.WMSGetCapabilities;
import org.geowebcache.service.wms.WMSRequests;
import org.geowebcache.service.wms.WMSTileFuser;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;

public class WMSService
extends Service {
    public static final String SERVICE_WMS = "wms";
    private static Log log = LogFactory.getLog(WMSService.class);
    private boolean fullWMS = false;
    private boolean proxyRequests = false;
    private boolean proxyNonTiledRequests = false;
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private RuntimeStats stats;

    public WMSService(StorageBroker sb, TileLayerDispatcher tld, RuntimeStats stats) {
        super(SERVICE_WMS);
        this.sb = sb;
        this.tld = tld;
        this.stats = stats;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        String encoding = request.getCharacterEncoding();
        String[] keys = new String[]{"layers", "request", "tiled", "cached", "metatiled", "width", "height"};
        String[] values = ServletUtils.selectedStringsFromMap(request.getParameterMap(), encoding, keys);
        String req = values[1];
        if (req != null && !req.equalsIgnoreCase("getmap")) {
            if (values[0] == null || values[0].length() == 0) {
                values[0] = ServletUtils.stringFromMap(request.getParameterMap(), encoding, "layer");
            }
            ConveyorTile tile = new ConveyorTile(this.sb, values[0], request, response);
            tile.setHint(req.toLowerCase());
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (this.proxyNonTiledRequests && (values[2] == null || !values[2].equalsIgnoreCase("true"))) {
            ConveyorTile tile = new ConveyorTile(this.sb, values[0], request, response);
            tile.setHint(req);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        String layers = values[0];
        if (layers == null) {
            throw new ServiceException("Unable to parse layers parameter from request.");
        }
        TileLayer tileLayer = this.tld.getTileLayer(layers);
        String[] paramKeys = new String[]{"format", "srs", "bbox"};
        String[] paramValues = ServletUtils.selectedStringsFromMap(request.getParameterMap(), encoding, paramKeys);
        String[] modStrs = null;
        if (tileLayer instanceof WMSLayer) {
            modStrs = ((WMSLayer)tileLayer).getModifiableParameters(request.getParameterMap(), encoding);
        }
        if (modStrs == null) {
            modStrs = new String[]{null, null};
        }
        MimeType mimeType = null;
        try {
            mimeType = MimeType.createFromFormat(paramValues[0]);
        }
        catch (MimeException me) {
            throw new ServiceException("Unable to determine requested format, " + paramValues[0]);
        }
        if (paramValues[1] == null) {
            throw new ServiceException("No SRS specified");
        }
        SRS srs = SRS.getSRS(paramValues[1]);
        GridSubset gridSubset = tileLayer.getGridSubsetForSRS(srs);
        if (gridSubset == null) {
            throw new ServiceException("Unable to match requested SRS " + paramValues[1] + " to those supported by layer");
        }
        BoundingBox bbox = null;
        try {
            bbox = new BoundingBox(paramValues[2]);
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)nfe.getMessage());
        }
        if (bbox == null || !bbox.isSane()) {
            throw new ServiceException("The bounding box parameter (" + paramValues[2] + ") is missing or not sane");
        }
        long[] tileIndex = gridSubset.closestIndex(bbox);
        int tileWidth = Integer.parseInt(values[5]);
        int tileHeight = Integer.parseInt(values[6]);
        if (this.fullWMS && (gridSubset.getTileWidth() != tileWidth || gridSubset.getTileHeight() != tileHeight || !bbox.equals(gridSubset.boundsFromIndex(tileIndex), 0.05))) {
            log.debug((Object)"Recombinining tiles to respond to WMS request");
            ConveyorTile tile = new ConveyorTile(this.sb, layers, request, response);
            tile.setHint("getmap");
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        gridSubset.checkTileDimensions(tileWidth, tileHeight);
        return new ConveyorTile(this.sb, layers, gridSubset.getName(), tileIndex, mimeType, modStrs[0], modStrs[1], request, response);
    }

    public void handleRequest(Conveyor conv) throws GeoWebCacheException {
        ConveyorTile tile = (ConveyorTile)conv;
        if (tile.getHint() != null) {
            if (tile.getHint().equalsIgnoreCase("getcapabilities")) {
                WMSGetCapabilities wmsCap = new WMSGetCapabilities(this.tld, tile.servletReq);
                wmsCap.writeResponse(tile.servletResp);
            } else if (tile.getHint().equalsIgnoreCase("getmap")) {
                WMSTileFuser wmsFuser = new WMSTileFuser(this.tld, this.sb, tile.servletReq);
                try {
                    wmsFuser.writeResponse(tile.servletResp, this.stats);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (tile.getHint().equalsIgnoreCase("getfeatureinfo")) {
                this.handleGetFeatureInfo(tile);
            } else {
                WMSRequests.handleProxy(this.tld, tile);
            }
        } else {
            throw new GeoWebCacheException("The WMS Service would love to help, but has no idea what you're trying to do?Please include request URL if you file a bug report.");
        }
    }

    private void handleGetFeatureInfo(ConveyorTile tile) throws GeoWebCacheException {
        WMSLayer layer = null;
        TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
        if (tl == null) {
            throw new GeoWebCacheException(tile.getLayerId() + " is unknown.");
        }
        if (!(tl instanceof WMSLayer)) {
            throw new GeoWebCacheException(tile.getLayerId() + " is not served by a WMS backend.");
        }
        layer = (WMSLayer)tl;
        String[] keys = new String[]{"x", "y", "srs", "info_format", "bbox"};
        String[] values = ServletUtils.selectedStringsFromMap(tile.servletReq.getParameterMap(), tile.servletReq.getCharacterEncoding(), keys);
        GridSubset gridSubset = tl.getGridSubsetForSRS(SRS.getSRS(values[2]));
        BoundingBox bbox = null;
        try {
            bbox = new BoundingBox(values[4]);
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)nfe.getMessage());
        }
        if (bbox == null || !bbox.isSane()) {
            throw new ServiceException("The bounding box parameter (" + values[2] + ") is missing or not sane");
        }
        long[] tileIndex = gridSubset.closestIndex(bbox);
        MimeType mimeType = MimeType.createFromFormat(values[3]);
        ConveyorTile gfiConv = new ConveyorTile(this.sb, tl.getName(), gridSubset.getName(), tileIndex, mimeType, null, null, tile.servletReq, tile.servletResp);
        gfiConv.setTileLayer(tl);
        WMSSourceHelper srcHelper = layer.getSourceHelper();
        byte[] data = srcHelper.makeFeatureInfoRequest(gfiConv, Integer.parseInt(values[0]), Integer.parseInt(values[1]));
        try {
            tile.servletResp.setContentType(mimeType.getMimeType());
            tile.servletResp.getOutputStream().write(data);
        }
        catch (IOException ioe) {
            tile.servletResp.setStatus(500);
            log.error((Object)ioe.getMessage());
        }
    }

    public void setFullWMS(String trueFalse) {
        this.fullWMS = Boolean.parseBoolean(trueFalse);
        if (this.fullWMS) {
            log.info((Object)"Will recombine tiles for non-tiling clients.");
        } else {
            log.info((Object)"Will NOT recombine tiles for non-tiling clients.");
        }
    }

    public void setProxyRequests(String trueFalse) {
        this.proxyRequests = Boolean.parseBoolean(trueFalse);
        if (this.proxyRequests) {
            log.info((Object)"Will proxy requests to backend that are not getmap or getcapabilities.");
        } else {
            log.info((Object)"Will NOT proxy non-getMap requests to backend.");
        }
    }

    public void setProxyNonTiledRequests(String trueFalse) {
        this.proxyNonTiledRequests = Boolean.parseBoolean(trueFalse);
        if (this.proxyNonTiledRequests) {
            log.info((Object)"Will proxy requests that miss tiled=true to backend.");
        } else {
            log.info((Object)"Will NOT proxy requests that miss tiled=true to backend.");
        }
    }
}

