/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSet;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.wmts.WMTSService;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.util.ServletUtils;

public class WMTSGetFeatureInfo {
    private static Log log = LogFactory.getLog(WMTSService.class);
    private ConveyorTile convTile;
    private String[] values;
    int i;
    int j;

    protected WMTSGetFeatureInfo(ConveyorTile convTile) throws OWSException {
        String[] keys = new String[]{"i", "j"};
        this.values = ServletUtils.selectedStringsFromMap(convTile.servletReq.getParameterMap(), convTile.servletReq.getCharacterEncoding(), keys);
        try {
            this.i = Integer.parseInt(this.values[0]);
        }
        catch (NumberFormatException nfe) {
            throw new OWSException(400, "MissingParameterValue", "I", "I was not specified");
        }
        try {
            this.j = Integer.parseInt(this.values[1]);
        }
        catch (NumberFormatException nfe) {
            throw new OWSException(400, "MissingParameterValue", "J", "J was not specified");
        }
        this.convTile = convTile;
    }

    protected void writeResponse(RuntimeStats stats) throws OWSException {
        GridSet gridSet;
        TileLayer layer = this.convTile.getLayer();
        WMSLayer wmsLayer = null;
        if (layer instanceof WMSLayer) {
            wmsLayer = (WMSLayer)layer;
        }
        if ((gridSet = this.convTile.getGridSubset().getGridSet()).getTileHeight() < this.j || this.j < 0) {
            throw new OWSException(400, "PointIJOutOfRange", "J", "J was " + this.j + ", must be between 0 and " + gridSet.getTileHeight());
        }
        if (gridSet.getTileWidth() < this.i || this.i < 0) {
            throw new OWSException(400, "PointIJOutOfRange", "I", "I was " + this.i + ", must be between 0 and " + gridSet.getTileWidth());
        }
        byte[] data = null;
        try {
            data = wmsLayer.getFeatureInfo(this.convTile, this.i, this.j);
        }
        catch (GeoWebCacheException e) {
            throw new OWSException(500, "NoApplicableCode", "", e.getMessage());
        }
        this.convTile.servletResp.setStatus(200);
        this.convTile.servletResp.setContentType(this.convTile.getMimeType().getMimeType());
        this.convTile.servletResp.setContentLength(data.length);
        stats.log(data.length, Conveyor.CacheResult.OTHER);
        try {
            ServletOutputStream os = this.convTile.servletResp.getOutputStream();
            os.write(data);
            os.flush();
        }
        catch (IOException ioe) {
            log.debug((Object)("Caught IOException" + ioe.getMessage()));
        }
    }
}

