/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.IOException;
import javax.servlet.ServletOutputStream;

public class AccountingOutputStream
extends ServletOutputStream {
    final ServletOutputStream os;
    int count = 0;

    public AccountingOutputStream(ServletOutputStream os) {
        this.os = os;
    }

    public void write(int b) throws IOException {
        ++this.count;
        this.os.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.count += b.length;
        this.os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.count += len;
        this.os.write(b, off, len);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void close() throws IOException {
        this.os.close();
    }

    public int getCount() {
        return this.count;
    }
}

