/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtils {
    private static Log log = LogFactory.getLog(ServletUtils.class);
    private static Calendar calendar = new GregorianCalendar();
    private static TimeZone timeZone = TimeZone.getTimeZone("GMT");
    private static SimpleDateFormat format = null;
    private static long localOffset = TimeZone.getDefault().getRawOffset();

    public static String[] stringsFromMap(Map<String, String[]> map, String encoding, String key) {
        String[] strArray = map.get(key);
        if (strArray != null) {
            return strArray;
        }
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return ServletUtils.URLDecode(entry.getValue(), encoding);
        }
        return null;
    }

    public static String stringFromMap(Map<String, String[]> map, String encoding, String key) {
        String[] strArray = ServletUtils.stringsFromMap(map, encoding, key);
        if (strArray != null) {
            return strArray[0];
        }
        return null;
    }

    public static String[][] selectedStringArraysFromMap(Map<String, String[]> map, String encoding, String[] keys) {
        String[][] retAr = new String[keys.length][];
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            for (int i = 0; i < keys.length; ++i) {
                if (!key.equalsIgnoreCase(keys[i])) continue;
                retAr[i] = ServletUtils.URLDecode(entry.getValue(), encoding);
            }
        }
        return retAr;
    }

    public static String[] selectedStringsFromMap(Map<String, String[]> map, String encoding, String[] keys) {
        String[] retAr = new String[keys.length];
        block0: for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            for (int i = 0; i < keys.length; ++i) {
                if (!key.equalsIgnoreCase(keys[i])) continue;
                retAr[i] = ServletUtils.URLDecode(entry.getValue()[0], encoding);
                continue block0;
            }
        }
        return retAr;
    }

    public static byte[] readStream(InputStream is, int bufferHint, int tmpBufferSize) throws IOException {
        return ServletUtils.readStream(is, bufferHint, tmpBufferSize, true);
    }

    public static byte[] readStream(InputStream is, int bufferHint, int tmpBufferSize, boolean close) throws IOException {
        byte[] buffer = null;
        buffer = bufferHint > 0 ? new byte[bufferHint] : new byte[10240];
        byte[] tmpBuffer = null;
        tmpBuffer = tmpBufferSize > 0 ? new byte[tmpBufferSize] : new byte[1024];
        int totalCount = 0;
        int c = is.read(tmpBuffer);
        while (c != -1) {
            if (c != 0) {
                if ((totalCount += c) >= buffer.length) {
                    int newLength = buffer.length * 2;
                    if (newLength < totalCount) {
                        newLength = totalCount;
                    }
                    byte[] newBuffer = new byte[newLength];
                    System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                    buffer = newBuffer;
                }
                System.arraycopy(tmpBuffer, 0, buffer, totalCount - c, c);
            }
            c = is.read(tmpBuffer);
        }
        if (close) {
            is.close();
        }
        byte[] newBuffer = new byte[totalCount];
        System.arraycopy(buffer, 0, newBuffer, 0, totalCount);
        return newBuffer;
    }

    public static String makeExpiresHeader(int seconds) {
        return ServletUtils.formatTimestamp(System.currentTimeMillis() + (long)seconds * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestamp(long timestamp) {
        String ret;
        Calendar calendar = ServletUtils.calendar;
        synchronized (calendar) {
            if (format == null) {
                format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                format.setTimeZone(timeZone);
            }
            ServletUtils.calendar.setTimeInMillis(timestamp);
            ret = format.format(ServletUtils.calendar.getTime());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseExpiresHeader(String expiresHeader) {
        long ret;
        if (expiresHeader == null) {
            return -1L;
        }
        Calendar calendar = ServletUtils.calendar;
        synchronized (calendar) {
            if (format == null) {
                format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                format.setTimeZone(timeZone);
            }
            try {
                format.parse(expiresHeader);
            }
            catch (ParseException pe) {
                log.debug((Object)("Cannot parse " + expiresHeader + ", " + pe.getMessage()));
                return -1L;
            }
            ret = ServletUtils.calendar.getTimeInMillis() - System.currentTimeMillis() - localOffset;
        }
        return ret;
    }

    public static String hexOfBytes(byte[] bytes) {
        StringBuilder str = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            str.append(ServletUtils.hexOfByte(bytes[i]));
        }
        return str.toString();
    }

    public static String hexOfByte(byte aByte) {
        char[] str = new char[2];
        for (int i = 0; i < 2; ++i) {
            int temp = aByte;
            if (temp < 0) {
                temp += 256;
            }
            temp = i == 0 ? (temp /= 16) : (temp %= 16);
            if (temp > 9) {
                switch (temp) {
                    case 10: {
                        str[i] = 65;
                        break;
                    }
                    case 11: {
                        str[i] = 66;
                        break;
                    }
                    case 12: {
                        str[i] = 67;
                        break;
                    }
                    case 13: {
                        str[i] = 68;
                        break;
                    }
                    case 14: {
                        str[i] = 69;
                        break;
                    }
                    case 15: {
                        str[i] = 70;
                    }
                }
                continue;
            }
            str[i] = (char)temp;
        }
        return new String(str);
    }

    public static String URLEncode(String str) {
        String ret = null;
        try {
            ret = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)e.getMessage());
        }
        return ret;
    }

    public static String URLDecode(String str, String encoding) {
        String ret = null;
        if (encoding != null) {
            try {
                ret = URLDecoder.decode(str, encoding);
            }
            catch (UnsupportedEncodingException e) {
                log.debug((Object)e.getMessage());
            }
        }
        try {
            ret = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.debug((Object)e1.getMessage());
        }
        return ret;
    }

    private static String[] URLDecode(String[] values, String encoding) {
        String[] decodedValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            decodedValues[i] = ServletUtils.URLDecode(values[i], encoding);
        }
        return decodedValues;
    }

    public static String gwcHtmlHeader(String pageTitle) {
        return "<head>\n<title>" + pageTitle + "</title>" + "<style type=\"text/css\">\n" + "body, td {\n" + "font-family: Verdana,Arial,'Bitstream Vera Sans',Helvetica,sans-serif;\n" + "font-size: 0.85em;\n" + "vertical-align: top;\n" + "}\n" + "</style>\n" + "</head>\n";
    }

    public static String gwcHtmlLogoLink(String relBasePath) {
        return "<a id=\"logo\" href=\"http://geowebcache.org\"><img src=\"" + relBasePath + "rest/web/geowebcache_logo.png\"" + "height=\"70\" width=\"247\" border=\"0\"/>" + "</a>\n";
    }

    public static long[][] arrayDeepCopy(long[][] array) {
        long[][] ret = new long[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, ret[i], 0, array[i].length);
        }
        return ret;
    }
}

