/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.sql.SQLException;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;

public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    public String getConstraintType() {
        return "CHECK";
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.filter = tableFilter;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER TABLE ");
        stringBuffer.append(table.getSQL());
        stringBuffer.append(" ADD CONSTRAINT ");
        stringBuffer.append(string);
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuffer.append(" CHECK");
        stringBuffer.append(StringUtils.enclose(this.expr.getSQL()));
        stringBuffer.append(" NOCHECK");
        return stringBuffer.toString();
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(": ");
        stringBuffer.append(this.expr.getSQL());
        return stringBuffer.toString();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) throws SQLException {
        if (row2 == null) {
            return;
        }
        this.filter.set(row2);
        if (Boolean.FALSE.equals(this.expr.getValue(session).getBoolean())) {
            throw Message.getSQLException(23000, this.getShortDescription());
        }
    }

    public boolean usesIndex(Index index) {
        return false;
    }

    public void setIndexOwner(Index index) {
        throw Message.getInternalError();
    }

    public boolean containsColumn(Column column) {
        String string = column.getSQL();
        String string2 = this.getCreateSQL();
        return string2.indexOf(string) >= 0;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public boolean isBefore() {
        return true;
    }

    public void checkExistingData(Session session) throws SQLException {
        if (session.getDatabase().isStarting()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT 1 FROM ");
        stringBuffer.append(this.filter.getTable().getSQL());
        stringBuffer.append(" WHERE NOT(");
        stringBuffer.append(this.expr.getSQL());
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        LocalResult localResult = session.prepare(string).query(1);
        if (localResult.next()) {
            throw Message.getSQLException(23000, this.getName());
        }
    }

    public Index getUniqueIndex() {
        return null;
    }

    public void rebuild() throws SQLException {
    }
}

