/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.time.Time;
import org.geotools.util.logging.Logging;

public class GeoServerResourceStreamLocator
extends ResourceStreamLocator {
    public static Logger LOGGER = Logging.getLogger((String)"org.geoserver.web");
    static Pattern GS_PROPERTIES = Pattern.compile("GeoServerApplication.*.properties");
    static Pattern GS_LOCAL_I18N = Pattern.compile("org/geoserver/.*(\\.properties|\\.xml)]");

    public IResourceStream locate(Class clazz, String path) {
        int i = path.lastIndexOf("/");
        if (i != -1) {
            String p = path.substring(i + 1);
            if (GS_PROPERTIES.matcher(p).matches()) {
                try {
                    Enumeration<URL> urls = ((Object)((Object)this)).getClass().getClassLoader().getResources(p);
                    Properties properties = new Properties();
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        InputStream in = url.openStream();
                        properties.load(in);
                        in.close();
                    }
                    final ByteArrayOutputStream out = new ByteArrayOutputStream();
                    properties.store(out, "");
                    return new AbstractResourceStream(){

                        public InputStream getInputStream() throws ResourceStreamNotFoundException {
                            return new ByteArrayInputStream(out.toByteArray());
                        }

                        public void close() throws IOException {
                            out.close();
                        }
                    };
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            } else {
                if (GS_LOCAL_I18N.matcher(path).matches()) {
                    return null;
                }
                if (path.matches("org/geoserver/.*" + clazz.getName() + ".*_.*.html")) {
                    return null;
                }
            }
        }
        return super.locate(clazz, path);
    }

    protected IResourceStream locateByClassLoader(Class clazz, String path) {
        URL url;
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if ((url = classLoader.getResource(path)) != null) {
            return new UrlResourceStream(url);
        }
        return null;
    }

    static class UrlResourceStream
    extends AbstractResourceStream
    implements IFixedLocationResourceStream {
        private static final long serialVersionUID = 1L;
        private transient InputStream inputStream;
        private final URL url;
        private File file;
        private int contentLength;
        private String contentType;
        private long lastModified;

        public UrlResourceStream(URL url) {
            this.url = url;
            URLConnection connection = null;
            try {
                connection = url.openConnection();
                this.contentLength = connection.getContentLength();
                this.contentType = connection.getContentType();
                try {
                    this.file = new File(new URI(url.toExternalForm()));
                }
                catch (Exception ex) {
                    LOGGER.fine("cannot convert url: " + url + " to file (" + ex.getMessage() + "), falling back to the inputstream for polling");
                }
                if (this.file != null && !this.file.exists()) {
                    this.file = null;
                }
            }
            catch (IOException ex) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid URL parameter " + url);
                illegalArgumentException.initCause(ex);
                throw illegalArgumentException;
            }
            finally {
                if (connection != null) {
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).disconnect();
                    } else {
                        try {
                            connection.getInputStream().close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
        }

        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }

        public String getContentType() {
            this.testContentType();
            return this.contentType;
        }

        private void testContentType() {
            if (this.contentType == null || this.contentType.indexOf("unknown") != -1) {
                Application application = Application.get();
                if (application instanceof WebApplication) {
                    this.contentType = ((WebApplication)application).getServletContext().getMimeType(this.url.getFile());
                    if (this.contentType == null) {
                        this.contentType = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
                    }
                } else {
                    this.contentType = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
                }
            }
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            if (this.inputStream == null) {
                try {
                    this.inputStream = this.url.openStream();
                }
                catch (IOException e) {
                    throw new ResourceStreamNotFoundException("Resource " + this.url + " could not be opened", (Throwable)e);
                }
            }
            return this.inputStream;
        }

        public URL getURL() {
            return this.url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Time lastModifiedTime() {
            if (this.file != null) {
                long lastModified = this.file.lastModified();
                if (lastModified != this.lastModified) {
                    this.lastModified = lastModified;
                    this.contentLength = (int)this.file.length();
                }
            } else {
                URLConnection urlConnection = null;
                boolean close = false;
                try {
                    urlConnection = this.url.openConnection();
                    long lastModified = this.lastModified;
                    if (urlConnection instanceof JarURLConnection) {
                        JarURLConnection jarUrlConnection = (JarURLConnection)urlConnection;
                        URL jarFileUrl = jarUrlConnection.getJarFileURL();
                        URLConnection jarFileConnection = jarFileUrl.openConnection();
                        try {
                            lastModified = jarFileConnection.getLastModified();
                        }
                        finally {
                            jarFileConnection.getInputStream().close();
                        }
                    } else {
                        close = true;
                        lastModified = urlConnection.getLastModified();
                    }
                    if (lastModified != this.lastModified) {
                        this.lastModified = lastModified;
                        close = true;
                        this.contentLength = urlConnection.getContentLength();
                    }
                }
                catch (IOException e) {
                    if (this.url.toString().indexOf(".jar!") >= 0) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("getLastModified for " + this.url + " failed: " + e.getMessage());
                        }
                    } else {
                        LOGGER.severe("getLastModified for " + this.url + " failed: " + e.getMessage());
                    }
                }
                finally {
                    if (urlConnection != null) {
                        if (urlConnection instanceof HttpURLConnection) {
                            ((HttpURLConnection)urlConnection).disconnect();
                        } else if (close) {
                            try {
                                urlConnection.getInputStream().close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            return Time.milliseconds((long)this.lastModified);
        }

        public String toString() {
            return this.url.toString();
        }

        public long length() {
            return this.contentLength;
        }

        public String locationAsString() {
            return this.url.toExternalForm();
        }
    }
}

