/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.JAIInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.admin.ServerAdminPage;

public class JAIPage
extends ServerAdminPage {
    private static final long serialVersionUID = -1184717232184497578L;

    public JAIPage() {
        final IModel geoServerModel = this.getGeoServerModel();
        final IModel jaiModel = this.getJAIModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)jaiModel));
        this.add((Component)form);
        NumberValidator percentageValidator = NumberValidator.range((long)0L, (long)1L);
        TextField memoryCapacity = new TextField("memoryCapacity");
        memoryCapacity.add((IValidator)percentageValidator);
        form.add((Component)memoryCapacity);
        TextField memoryThreshold = new TextField("memoryThreshold");
        memoryThreshold.add((IValidator)percentageValidator);
        form.add((Component)memoryThreshold);
        TextField tileThreads = new TextField("tileThreads");
        tileThreads.add((IValidator)NumberValidator.POSITIVE);
        form.add((Component)tileThreads);
        TextField tilePriority = new TextField("tilePriority");
        tilePriority.add((IValidator)NumberValidator.POSITIVE);
        form.add((Component)tilePriority);
        form.add((Component)new CheckBox("recycling"));
        form.add((Component)new CheckBox("imageIOCache"));
        form.add((Component)new CheckBox("jpegAcceleration"));
        form.add((Component)new CheckBox("pngAcceleration"));
        form.add((Component)new CheckBox("allowNativeMosaic"));
        Button submit = new Button("submit", (IModel)new StringResourceModel("submit", (Component)this, null)){

            public void onSubmit() {
                GeoServer gs = (GeoServer)geoServerModel.getObject();
                gs.getGlobal().setJAI((JAIInfo)jaiModel.getObject());
                gs.save(gs.getGlobal());
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)submit);
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)cancel);
    }
}

