/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

class StoreNameValidator
implements IFormValidator {
    FormComponent workspaceComponent;
    FormComponent storeNameComponent;
    private String edittingStoreId;

    public StoreNameValidator(FormComponent workspaceFormComponent, FormComponent storeNameFormComponent, String edittingStoreId) {
        this.workspaceComponent = workspaceFormComponent;
        this.storeNameComponent = storeNameFormComponent;
        this.edittingStoreId = edittingStoreId;
    }

    public FormComponent[] getDependentFormComponents() {
        return new FormComponent[]{this.workspaceComponent, this.storeNameComponent};
    }

    public void validate(Form form) {
        String existingId;
        FormComponent[] components = this.getDependentFormComponents();
        FormComponent wsComponent = components[0];
        FormComponent nameComponent = components[1];
        WorkspaceInfo workspace = (WorkspaceInfo)wsComponent.getConvertedInput();
        String name = (String)nameComponent.getConvertedInput();
        if (name == null) {
            ValidationError error = new ValidationError();
            error.addMessageKey("StoreNameValidator.storeNameRequired");
            nameComponent.error((IValidationError)error);
            return;
        }
        Catalog catalog = GeoServerApplication.get().getCatalog();
        StoreInfo existing = catalog.getStoreByName(workspace, name, StoreInfo.class);
        if (existing != null && !(existingId = existing.getId()).equals(this.edittingStoreId)) {
            ValidationError error = new ValidationError();
            error.addMessageKey("StoreNameValidator.storeExistsInWorkspace");
            error.setVariable("workspace", (Object)workspace.getName());
            error.setVariable("storeName", (Object)name);
            nameComponent.error((IValidationError)error);
        }
    }
}

