/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.namespace.NamespaceDetachableModel;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.URIValidator;
import org.geoserver.web.wicket.XMLNameValidator;
import org.geotools.util.logging.Logging;

public class WorkspaceEditPage
extends GeoServerSecuredPage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.data.workspace");
    IModel wsModel;
    IModel nsModel;
    boolean defaultWs;

    public WorkspaceEditPage(PageParameters parameters) {
        String wsName = parameters.getString("name");
        WorkspaceInfo wsi = this.getCatalog().getWorkspaceByName(wsName);
        if (wsi == null) {
            this.error((Serializable)((Object)new ParamResourceModel("WorkspaceEditPage.notFound", (Component)this, wsName).getString()));
            this.setResponsePage(WorkspacePage.class);
            return;
        }
        this.init(wsi);
    }

    public WorkspaceEditPage(WorkspaceInfo ws) {
        this.init(ws);
    }

    private void init(WorkspaceInfo ws) {
        this.defaultWs = ws.getId().equals(this.getCatalog().getDefaultWorkspace().getId());
        this.wsModel = new WorkspaceDetachableModel(ws);
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(ws.getName());
        this.nsModel = new NamespaceDetachableModel(ns);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.nsModel)){

            protected void onSubmit() {
                try {
                    WorkspaceEditPage.this.saveWorkspace();
                }
                catch (RuntimeException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                }
            }
        };
        this.add((Component)form);
        TextField name = new TextField("name", (IModel)new PropertyModel((Object)this.wsModel, "name"));
        name.setRequired(true);
        name.add((IValidator)new XMLNameValidator());
        form.add((Component)name);
        TextField uri = new TextField("uri", (IModel)new PropertyModel((Object)this.nsModel, "uRI"), String.class);
        uri.setRequired(true);
        uri.add((IValidator)new URIValidator());
        form.add((Component)uri);
        CheckBox defaultChk = new CheckBox("default", (IModel)new PropertyModel((Object)this, "defaultWs"));
        form.add((Component)defaultChk);
        SubmitLink submit = new SubmitLink("save");
        form.add((Component)submit);
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add((Component)new BookmarkablePageLink("cancel", WorkspacePage.class));
    }

    private void saveWorkspace() {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = (NamespaceInfo)this.nsModel.getObject();
        WorkspaceInfo workspaceInfo = (WorkspaceInfo)this.wsModel.getObject();
        namespaceInfo.setPrefix(workspaceInfo.getName());
        catalog.save(workspaceInfo);
        catalog.save(namespaceInfo);
        if (this.defaultWs) {
            catalog.setDefaultWorkspace(workspaceInfo);
        }
        this.setResponsePage(WorkspacePage.class);
    }
}

