/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util;

import java.util.Locale;
import java.util.Set;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;

public class GeoToolsConverterLocator
implements IConverterLocator {
    public IConverter getConverter(Class type) {
        Set factories = Converters.getConverterFactories(String.class, (Class)type);
        if (!factories.isEmpty()) {
            return new GeoToolsConverter(factories, type);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GeoToolsConverter
    implements IConverter {
        Set<ConverterFactory> factories;
        Class target;

        GeoToolsConverter(Set<ConverterFactory> factories, Class target) {
            this.factories = factories;
            this.target = target;
        }

        public Object convertToObject(String value, Locale locale) {
            for (ConverterFactory factory : this.factories) {
                try {
                    Object converted;
                    Converter converter = factory.createConverter(String.class, this.target, null);
                    if (converter == null || (converted = converter.convert((Object)value, this.target)) == null) continue;
                    return converted;
                }
                catch (Exception e) {
                }
            }
            return null;
        }

        public String convertToString(Object value, Locale locale) {
            Set rconverters = Converters.getConverterFactories((Class)this.target, String.class);
            for (ConverterFactory cf : rconverters) {
                try {
                    String converted;
                    Converter converter = cf.createConverter(value.getClass(), String.class, null);
                    if (converter == null || (converted = (String)converter.convert(value, String.class)) == null) continue;
                    return converted;
                }
                catch (Exception e) {
                }
            }
            return value.toString();
        }
    }
}

