/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnvelopePanel
extends FormComponentPanel {
    Double minX;
    Double minY;
    Double maxX;
    Double maxY;
    CoordinateReferenceSystem crs;

    public EnvelopePanel(String id) {
        super(id);
        this.initComponents();
    }

    public EnvelopePanel(String id, ReferencedEnvelope e) {
        this(id, (IModel)new Model((Serializable)e));
    }

    public EnvelopePanel(String id, IModel model) {
        super(id, model);
        this.initComponents();
    }

    void initComponents() {
        this.updateFields();
        this.add((Component)new TextField("minX", (IModel)new PropertyModel((Object)this, "minX")));
        this.add((Component)new TextField("minY", (IModel)new PropertyModel((Object)this, "minY")));
        this.add((Component)new TextField("maxX", (IModel)new PropertyModel((Object)this, "maxX")));
        this.add((Component)new TextField("maxY", (IModel)new PropertyModel((Object)this, "maxY")));
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        ReferencedEnvelope e = (ReferencedEnvelope)this.getModelObject();
        if (e != null) {
            this.minX = e.getMinX();
            this.minY = e.getMinY();
            this.maxX = e.getMaxX();
            this.maxY = e.getMaxY();
            this.crs = e.getCoordinateReferenceSystem();
        }
    }

    public EnvelopePanel setReadOnly(final boolean readOnly) {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                component.setEnabled(!readOnly);
                return null;
            }
        });
        return this;
    }

    protected void convertInput() {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).processInput();
                return null;
            }
        });
        if (this.minX != null && this.maxX != null && this.minY != null && this.maxX != null) {
            this.setConvertedInput(new ReferencedEnvelope(this.minX.doubleValue(), this.maxX.doubleValue(), this.minY.doubleValue(), this.maxY.doubleValue(), this.crs));
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).clearInput();
                return CONTINUE_TRAVERSAL;
            }
        });
    }
}

