/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.SumVisitor;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountVisitor
implements FeatureCalc {
    int count = 0;

    public void init(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
    }

    @Override
    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void setValue(int count) {
        this.count = count;
    }

    public void reset() {
        this.count = 0;
    }

    @Override
    public CalcResult getResult() {
        return new CountResult(this.count);
    }

    public static class CountResult
    extends AbstractCalcResult {
        private int count;

        public CountResult(int newcount) {
            this.count = newcount;
        }

        public Object getValue() {
            return new Integer(this.count);
        }

        public boolean isCompatible(CalcResult targetResults) {
            if (targetResults instanceof CountResult) {
                return true;
            }
            return targetResults instanceof SumVisitor.SumResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof CountResult) {
                int toAdd = resultsToAdd.toInt();
                return new CountResult(this.count + toAdd);
            }
            if (resultsToAdd instanceof SumVisitor.SumResult) {
                return resultsToAdd.merge(this);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

