/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.property.PropertyAttributeReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.property");
    PropertyAttributeReader reader;

    public PropertyFeatureReader(File directory, String typeName) throws IOException {
        File file = new File(directory, typeName + ".properties");
        this.reader = new PropertyAttributeReader(file);
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.reader.type;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        this.reader.next();
        SimpleFeatureType type = this.reader.type;
        String fid = this.reader.getFeatureID();
        Object[] values = new Object[this.reader.getAttributeCount()];
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            try {
                values[i] = this.reader.read(i);
                continue;
            }
            catch (RuntimeException e) {
                values[i] = null;
                continue;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return SimpleFeatureBuilder.build(type, values, fid);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            LOGGER.warning("Stream seems to be already closed.");
        } else {
            this.reader.close();
        }
        this.reader = null;
    }
}

