/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.util.List;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.Hints;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.BaseCoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorAdapter;
import org.geotools.styling.StyleVisitor;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyleVisitorCoverageProcessingNodeAdapter
extends StyleVisitorAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private final CoverageProcessingNode adaptee;

    protected static void ensureSourceNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(3, name));
        }
    }

    protected static void ensureNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(8, name));
        }
    }

    protected CoverageProcessingNode getAdaptee() {
        return this.adaptee;
    }

    public StyleVisitorCoverageProcessingNodeAdapter(CoverageProcessingNode adaptee) {
        StyleVisitorCoverageProcessingNodeAdapter.ensureNotNull(adaptee, "CoverageProcessingNode");
        this.adaptee = adaptee;
    }

    public StyleVisitorCoverageProcessingNodeAdapter(InternationalString name, InternationalString description) {
        this(-1, name, description);
    }

    public StyleVisitorCoverageProcessingNodeAdapter(int maxSources, InternationalString name, InternationalString description) {
        this(maxSources, null, name, description);
    }

    public StyleVisitorCoverageProcessingNodeAdapter(int maxSources, Hints hints, InternationalString name, InternationalString description) {
        this.adaptee = new BaseCoverageProcessingNode(maxSources, hints != null ? hints.clone() : null, name, description){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected GridCoverage execute() {
                StyleVisitorCoverageProcessingNodeAdapter styleVisitorCoverageProcessingNodeAdapter = StyleVisitorCoverageProcessingNodeAdapter.this;
                synchronized (styleVisitorCoverageProcessingNodeAdapter) {
                    return StyleVisitorCoverageProcessingNodeAdapter.this.execute();
                }
            }
        };
    }

    protected abstract GridCoverage execute();

    @Override
    public void addSink(CoverageProcessingNode sink) {
        this.adaptee.addSink(sink);
    }

    @Override
    public boolean addSource(CoverageProcessingNode source) {
        return this.adaptee.addSource(source);
    }

    @Override
    public GridCoverage getOutput() {
        return this.adaptee.getOutput();
    }

    @Override
    public CoverageProcessingNode getSink(int index) {
        return this.adaptee.getSink(index);
    }

    @Override
    public List<CoverageProcessingNode> getSinks() {
        return this.adaptee.getSinks();
    }

    @Override
    public CoverageProcessingNode getSource(int index) {
        return this.adaptee.getSource(index);
    }

    @Override
    public List<CoverageProcessingNode> getSources() {
        return this.adaptee.getSources();
    }

    @Override
    public boolean removeSink(CoverageProcessingNode sink) {
        return this.adaptee.removeSink(sink);
    }

    @Override
    public CoverageProcessingNode removeSink(int index) {
        return this.adaptee.removeSink(index);
    }

    @Override
    public boolean removeSource(CoverageProcessingNode source) {
        return this.adaptee.removeSource(source);
    }

    @Override
    public CoverageProcessingNode removeSource(int index) {
        return this.adaptee.removeSource(index);
    }

    @Override
    public void dispose(boolean force) {
        this.adaptee.dispose(force);
    }

    @Override
    public Hints getHints() {
        return this.adaptee.getHints();
    }

    @Override
    public GridCoverageFactory getCoverageFactory() {
        return this.adaptee.getCoverageFactory();
    }

    @Override
    public int getNumberOfSinks() {
        return this.adaptee.getNumberOfSinks();
    }

    @Override
    public int getNumberOfSources() {
        return this.adaptee.getNumberOfSources();
    }

    @Override
    public InternationalString getDescription() {
        return this.adaptee.getDescription();
    }

    @Override
    public InternationalString getName() {
        return this.adaptee.getName();
    }

    @Override
    public String toString() {
        return ((Object)this.adaptee).toString();
    }
}

