/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.util.Vector;
import simple.http.Dispatcher;
import simple.http.Monitor;
import simple.http.Pipeline;
import simple.http.Poller;
import simple.http.PollerFactory;
import simple.http.PollerHandler;
import simple.http.Processor;
import simple.http.ProtocolHandler;
import simple.util.process.ProcessQueue;
import simple.util.schedule.PulseScheduler;
import simple.util.schedule.Scheduler;

final class PipelineProcessor
implements PollerHandler {
    private static ProcessQueue engine = ProcessQueue.getInstance();
    protected ProtocolHandler handler;
    protected Scheduler queue;
    protected Vector active;

    public PipelineProcessor(ProtocolHandler handler, int threads, int wait) {
        this.queue = new PulseScheduler(wait);
        this.active = new Vector(threads);
        this.handler = handler;
        this.init(threads);
    }

    private void init(int size) {
        while (this.active.size() < size) {
            Processor run = new Processor(this, this.queue);
            this.active.add(run);
            new Thread(run).start();
        }
    }

    public void process(Pipeline pipe) throws IOException, InterruptedException {
        this.queue.enqueue(PollerFactory.getInstance(pipe), 0L);
    }

    public void notifyReady(Poller poller) throws IOException, InterruptedException {
        Monitor mon = new Monitor(this, poller);
        engine.execute(new Dispatcher(this.handler, poller, mon));
    }

    public void notifyWait(Poller poller) throws InterruptedException {
        this.queue.enqueue(poller, 0L);
    }

    public void notifyWait(Poller poller, int sleep) throws InterruptedException {
        this.queue.enqueue(poller, sleep);
    }
}

