/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.kvp.GetMapKvpRequestReader;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;

public class GetFeatureInfoKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers.wms");
    private GetFeatureInfoRequest request;
    private GetMapKvpRequestReader getMapReader;

    public GetFeatureInfoKvpReader(Map kvpPairs, WMS wms) {
        super(kvpPairs, wms);
        this.getMapReader = new GetMapKvpRequestReader(wms);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        this.request = new GetFeatureInfoRequest(this.getWMS());
        this.request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        this.request.setVersion(version);
        GetMapRequest getMapPart = new GetMapRequest(this.getWMS());
        try {
            getMapPart = this.getMapReader.read((Object)getMapPart, this.kvpPairs, this.kvpPairs);
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
        this.request.setGetMapRequest(getMapPart);
        this.request.setQueryLayers(this.parseLayers(this.getWMS()));
        ArrayList<MapLayerInfo> getMapLayers = new ArrayList<MapLayerInfo>(Arrays.asList(getMapPart.getLayers()));
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>(Arrays.asList(this.request.getQueryLayers()));
        queryLayers.removeAll(getMapLayers);
        if (queryLayers.size() > 0) {
            throw new WmsException("QUERY_LAYERS contains layers not cited in LAYERS. It should be a proper subset of those instead");
        }
        String format = this.getValue("INFO_FORMAT");
        if (format == null) {
            format = "text/plain";
        } else {
            List formats = GetFeatureInfoResponse.getFormats();
            if (!formats.contains(format)) {
                throw new WmsException("Invalid format '" + format + "', supported formats are " + formats, "InvalidParameterValue", "info_format");
            }
        }
        this.request.setInfoFormat(format);
        this.request.setFeatureCount(1);
        try {
            int maxFeatures = Integer.parseInt(this.getValue("FEATURE_COUNT"));
            this.request.setFeatureCount(maxFeatures);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            int x = Integer.parseInt(this.getValue("X"));
            int y = Integer.parseInt(this.getValue("Y"));
            this.request.setXPixel(x);
            this.request.setYPixel(y);
        }
        catch (NumberFormatException ex) {
            throw new WmsException("X and Y incorrectly specified");
        }
        String exceptionsFormat = this.getValue("EXCEPTIONS");
        this.request.setExeptionFormat(exceptionsFormat);
        return this.request;
    }

    private MapLayerInfo[] parseLayers(WMS wms) throws WmsException {
        List queryLayers = GetFeatureInfoKvpReader.readFlat((String)this.getValue("QUERY_LAYERS"), (String)",");
        if (queryLayers.size() == 0) {
            throw new WmsException("No QUERY_LAYERS has been requested, or no queriable layer in the request anyways", ((Object)((Object)this)).getClass().getName());
        }
        ArrayList<MapLayerInfo> layerInfos = new ArrayList<MapLayerInfo>();
        for (String layerName : queryLayers) {
            LayerInfo layerInfo = wms.getLayerByName(layerName);
            if (layerInfo == null) {
                LayerGroupInfo layerGroup = wms.getLayerGroupByName(layerName);
                if (layerGroup == null) {
                    throw new WmsException("Layer " + layerName + " does not exist", "LayerNotDefined");
                }
                for (LayerInfo li : layerGroup.getLayers()) {
                    layerInfos.add(new MapLayerInfo(li));
                }
                continue;
            }
            layerInfos.add(new MapLayerInfo(layerInfo));
        }
        return layerInfos.toArray(new MapLayerInfo[layerInfos.size()]);
    }
}

