/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Geometry;
import it.geosolutions.imageio.stream.input.spi.URLImageInputStreamSpi;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RasterFactory;
import javax.media.jai.remote.SerializableRenderedImage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.gce.imagemosaic.FootprintUtils;
import org.geotools.gce.imagemosaic.IndexBuilder;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageMosaicUtils {
    static final Boolean IGNORE_FOOTPRINT = Boolean.getBoolean("org.geotools.footprint.ignore");
    static final AffineTransform CENTER_TO_CORNER = AffineTransform.getTranslateInstance(PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    static final AffineTransform CORNER_TO_CENTER = AffineTransform.getTranslateInstance(-PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), -PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicUtils.class.toString());
    static final String DEFAULT_WILCARD = "*.*";
    static final boolean DEFAULT_FOOTPRINT_MANAGEMENT = true;
    static final boolean DEFAULT_PATH_BEHAVIOR = false;
    private static ImageInputStreamSpi cachedStreamSPI = new URLImageInputStreamSpi();
    public static final int DEFAULT_PRIORITY = 5;
    public static final String DEFAULT_LOCATION_ATTRIBUTE = "location";
    public static final String DEFAULT_INDEX_NAME = "index";

    ImageMosaicUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createMosaic(String location, String indexName, String wildcard, boolean absolutePath) {
        IndexBuilder.IndexBuilderConfiguration configuration = new IndexBuilder.IndexBuilderConfiguration();
        configuration.setAbsolute(absolutePath);
        configuration.setRootMosaicDirectory(location);
        configuration.setIndexingDirectories(Arrays.asList(location));
        configuration.setIndexName(indexName);
        IndexBuilder indexBuilder = new IndexBuilder(configuration);
        final LinkedList exceptions = new LinkedList();
        try {
            IndexBuilder.ProcessingEventListener listener = new IndexBuilder.ProcessingEventListener(){

                public void exceptionOccurred(IndexBuilder.ExceptionEvent event) {
                    Exception t = event.getException();
                    exceptions.add(t);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                    }
                }

                public void getNotification(IndexBuilder.ProcessingEvent event) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(event.getMessage());
                    }
                }
            };
            indexBuilder.addProcessingEventListener(listener);
            indexBuilder.run();
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Unable to build mosaic", e);
            boolean bl = false;
            return bl;
        }
        finally {
            indexBuilder.dispose();
        }
        return exceptions.size() <= 0;
    }

    static String getMessageFromException(Exception exception) {
        if (exception.getLocalizedMessage() != null) {
            return exception.getLocalizedMessage();
        }
        return exception.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL checkSource(Object source) throws MalformedURLException, DataSourceException {
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = DataUtilities.fileToURL((File)sourceFile);
            sourceURL = ImageMosaicUtils.checkURLForMosaicQuery(sourceURL);
        } else if (source instanceof URL) {
            sourceURL = ImageMosaicUtils.checkURLForMosaicQuery((URL)source);
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile((URL)sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    sourceURL = ImageMosaicUtils.checkURLForMosaicQuery(sourceURL);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL((File)tempFile);
                sourceFile = tempFile;
            }
        }
        if (sourceFile != null) {
            if (!sourceFile.isDirectory()) {
                sourceURL = DataUtilities.fileToURL((File)sourceFile);
            } else {
                String locationPath = sourceFile.getAbsolutePath();
                String defaultWildcardString = DEFAULT_WILCARD;
                String defaultIndexName = FilenameUtils.getName((String)locationPath);
                File[] properties = sourceFile.listFiles((FilenameFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties")));
                File granuleIndex = null;
                for (File propFile : properties) {
                    File shpFile = new File(locationPath, FilenameUtils.getBaseName((String)propFile.getName()) + ".shp");
                    if (!shpFile.exists() || !shpFile.isFile() || !shpFile.canRead() || !propFile.canRead() || !propFile.isFile()) continue;
                    granuleIndex = shpFile;
                    break;
                }
                if (granuleIndex == null) {
                    ImageMosaicUtils.createMosaic(locationPath, defaultIndexName, DEFAULT_WILCARD, false);
                    granuleIndex = new File(locationPath, defaultIndexName + ".shp");
                    File propertiesFile = new File(locationPath, defaultIndexName + ".properties");
                    sourceURL = !(granuleIndex.exists() && granuleIndex.canRead() && propertiesFile.exists() && propertiesFile.canRead()) ? null : granuleIndex.toURI().toURL();
                } else if (!granuleIndex.exists() || !granuleIndex.canRead()) {
                    sourceURL = null;
                } else {
                    File sampleImageFile;
                    MosaicConfigurationBean props;
                    String shapeFileName = granuleIndex.getAbsolutePath();
                    String pathPrefix = FilenameUtils.getFullPathNoEndSeparator((String)shapeFileName) + File.separatorChar;
                    File footprintSummaryFile = new File(pathPrefix + FilenameUtils.getBaseName((String)shapeFileName) + ".fpt");
                    File footprintShapeFile = new File(pathPrefix + "footprint.shp");
                    if (footprintShapeFile != null && footprintShapeFile.exists() && footprintShapeFile.canRead() && footprintSummaryFile != null && !footprintSummaryFile.exists() && (props = ImageMosaicUtils.loadPropertiesFile(DataUtilities.fileToURL((File)granuleIndex), null, DEFAULT_LOCATION_ATTRIBUTE, FootprintUtils.IGNORE_PROPS)).footprintManagement) {
                        ShapefileDataStore footprintStore = null;
                        try {
                            HashMap<String, Geometry> footprintsLocationGeometryMap = new HashMap<String, Geometry>();
                            footprintStore = new ShapefileDataStore(DataUtilities.fileToURL((File)footprintShapeFile));
                            FootprintUtils.initFootprintsLocationGeometryMap(footprintStore, footprintsLocationGeometryMap);
                            FootprintUtils.writeFootprintSummary(footprintSummaryFile, granuleIndex, footprintsLocationGeometryMap);
                            footprintsLocationGeometryMap.clear();
                        }
                        catch (Throwable t) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                            }
                        }
                        finally {
                            try {
                                if (footprintStore != null) {
                                    footprintStore.dispose();
                                }
                            }
                            catch (Throwable e) {
                                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                            }
                            footprintStore = null;
                        }
                    }
                    if (!((sampleImageFile = new File(pathPrefix + "sample_image")).exists() && sampleImageFile.isFile() && sampleImageFile.canRead())) {
                        ImageMosaicUtils.createSampleImage(pathPrefix);
                    }
                    sourceURL = granuleIndex.toURI().toURL();
                }
            }
        }
        return sourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static RenderedImage loadSampleImage(File sampleImageFile) {
        block39: {
            block33: {
                block38: {
                    block32: {
                        inStream = null;
                        oiStream = null;
                        try {
                            try {
                                if (DataUtilities.checkFileReadable((File)sampleImageFile, (Logger)ImageMosaicUtils.LOGGER)) {
                                    inStream = new BufferedInputStream(new FileInputStream(sampleImageFile));
                                    oiStream = new ObjectInputStream(inStream);
                                    var3_3 = (RenderedImage)oiStream.readObject();
                                    var6_8 = null;
                                    break block32;
                                }
                                if (ImageMosaicUtils.LOGGER.isLoggable(Level.FINE)) {
                                    ImageMosaicUtils.LOGGER.warning("Unable to find sample image for path " + sampleImageFile);
                                }
                                var3_4 = null;
                                break block33;
                            }
                            catch (FileNotFoundException e) {
                                block34: {
                                    if (ImageMosaicUtils.LOGGER.isLoggable(Level.WARNING)) {
                                        ImageMosaicUtils.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                                    }
                                    var4_20 = null;
                                    var6_10 = null;
                                    try {
                                        if (inStream != null) {
                                            inStream.close();
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!ImageMosaicUtils.LOGGER.isLoggable(Level.FINE)) break block34;
                                        ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                try {
                                    if (oiStream == null) return var4_20;
                                    oiStream.close();
                                    return var4_20;
                                }
                                catch (Throwable e) {
                                    if (ImageMosaicUtils.LOGGER.isLoggable(Level.FINE) == false) return var4_20;
                                    ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                return var4_20;
                            }
                            catch (IOException e) {
                                block35: {
                                    if (ImageMosaicUtils.LOGGER.isLoggable(Level.WARNING)) {
                                        ImageMosaicUtils.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                                    }
                                    var4_21 = null;
                                    var6_11 = null;
                                    ** try [egrp 2[TRYBLOCK] [12 : 214->225)] { 
lbl46:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block35;
lbl49:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!ImageMosaicUtils.LOGGER.isLoggable(Level.FINE)) break block35;
                                        ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [13 : 255->266)] { 
lbl54:
                                // 1 sources

                                if (oiStream == null) return var4_21;
                                oiStream.close();
                                return var4_21;
lbl57:
                                // 1 sources

                                catch (Throwable e) {
                                    if (ImageMosaicUtils.LOGGER.isLoggable(Level.FINE) == false) return var4_21;
                                    ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                return var4_21;
                            }
                            catch (ClassNotFoundException e) {
                                block36: {
                                    if (ImageMosaicUtils.LOGGER.isLoggable(Level.WARNING)) {
                                        ImageMosaicUtils.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                                    }
                                    var4_22 = null;
                                    var6_12 = null;
                                    ** try [egrp 2[TRYBLOCK] [12 : 214->225)] { 
lbl68:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block36;
lbl71:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!ImageMosaicUtils.LOGGER.isLoggable(Level.FINE)) break block36;
                                        ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [13 : 255->266)] { 
lbl76:
                                // 1 sources

                                if (oiStream == null) return var4_22;
                                oiStream.close();
                                return var4_22;
lbl79:
                                // 1 sources

                                catch (Throwable e) {
                                    if (ImageMosaicUtils.LOGGER.isLoggable(Level.FINE) == false) return var4_22;
                                    ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                                return var4_22;
                            }
                        }
                        catch (Throwable var5_23) {
                            block37: {
                                var6_13 = null;
                                ** try [egrp 2[TRYBLOCK] [12 : 214->225)] { 
lbl87:
                                // 1 sources

                                if (inStream != null) {
                                    inStream.close();
                                }
                                break block37;
lbl90:
                                // 1 sources

                                catch (Throwable e) {
                                    if (!ImageMosaicUtils.LOGGER.isLoggable(Level.FINE)) break block37;
                                    ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                            }
                            try {}
                            catch (Throwable e) {
                                if (ImageMosaicUtils.LOGGER.isLoggable(Level.FINE) == false) throw var5_23;
                                ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                throw var5_23;
                            }
                            if (oiStream == null) throw var5_23;
                            oiStream.close();
                            throw var5_23;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [12 : 214->225)] { 
lbl104:
                    // 1 sources

                    if (inStream != null) {
                        inStream.close();
                    }
                    break block38;
lbl107:
                    // 1 sources

                    catch (Throwable e) {
                        if (!ImageMosaicUtils.LOGGER.isLoggable(Level.FINE)) break block38;
                        ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                ** try [egrp 3[TRYBLOCK] [13 : 255->266)] { 
lbl112:
                // 1 sources

                if (oiStream == null) return var3_3;
                oiStream.close();
                return var3_3;
lbl115:
                // 1 sources

                catch (Throwable e) {
                    if (ImageMosaicUtils.LOGGER.isLoggable(Level.FINE) == false) return var3_3;
                    ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                return var3_3;
            }
            var6_9 = null;
            ** try [egrp 2[TRYBLOCK] [12 : 214->225)] { 
lbl122:
            // 1 sources

            if (inStream != null) {
                inStream.close();
            }
            break block39;
lbl125:
            // 1 sources

            catch (Throwable e) {
                if (!ImageMosaicUtils.LOGGER.isLoggable(Level.FINE)) break block39;
                ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        try {}
        catch (Throwable e) {
            if (ImageMosaicUtils.LOGGER.isLoggable(Level.FINE) == false) return var3_4;
            ImageMosaicUtils.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return var3_4;
        }
        if (oiStream == null) return var3_4;
        oiStream.close();
        return var3_4;
    }

    private static synchronized void createSampleImage(String pathPrefix) {
        File sampleImageFile = new File(pathPrefix + "sample_image");
        if (!(sampleImageFile.exists() && sampleImageFile.isFile() && sampleImageFile.canRead())) {
            IOFileFilter finalFilter = IndexBuilder.createIndexingFilter((IOFileFilter)new WildcardFileFilter(DEFAULT_WILCARD, IOCase.INSENSITIVE));
            File directoryToScan = new File(pathPrefix);
            Collection files = FileUtils.listFiles((File)directoryToScan, (IOFileFilter)finalFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File file : files) {
                ImageTypeSpecifier its = ImageMosaicUtils.getImageTypeSpecifier(file);
                if (its == null) continue;
                ColorModel defaultCM = its.getColorModel();
                SampleModel defaultSM = its.getSampleModel();
                try {
                    ImageMosaicUtils.storeSampleImage(sampleImageFile, defaultSM, defaultCM);
                    break;
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static ImageTypeSpecifier getImageTypeSpecifier(File fileBeingProcessed) {
        ImageTypeSpecifier imageTypeSpecifier;
        ImageReader imageioReader;
        ImageInputStream inStream;
        block47: {
            Throwable e222222;
            block46: {
                ImageTypeSpecifier its;
                block43: {
                    ImageTypeSpecifier imageTypeSpecifier2;
                    block45: {
                        Throwable e222222;
                        block44: {
                            block40: {
                                ImageTypeSpecifier imageTypeSpecifier3;
                                block42: {
                                    Throwable e222222;
                                    block41: {
                                        String validFileName;
                                        if (!(fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile())) {
                                            return null;
                                        }
                                        try {
                                            validFileName = fileBeingProcessed.getCanonicalPath();
                                            validFileName = FilenameUtils.normalize((String)validFileName);
                                        }
                                        catch (IOException e1) {
                                            return null;
                                        }
                                        validFileName = FilenameUtils.getName((String)validFileName);
                                        inStream = null;
                                        imageioReader = null;
                                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                        if (inStream != null) break block40;
                                        imageTypeSpecifier3 = null;
                                        Object var8_9 = null;
                                        try {
                                            if (inStream != null) {
                                                inStream.close();
                                            }
                                        }
                                        catch (Throwable e222222) {
                                            if (!LOGGER.isLoggable(Level.FINEST)) break block41;
                                            LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                                        }
                                    }
                                    try {
                                        if (imageioReader != null) {
                                            imageioReader.dispose();
                                        }
                                    }
                                    catch (Throwable e222222) {
                                        if (!LOGGER.isLoggable(Level.FINEST)) break block42;
                                        LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                                    }
                                }
                                return imageTypeSpecifier3;
                            }
                            inStream.mark();
                            Iterator<ImageReader> it = ImageIO.getImageReaders(inStream);
                            if (it.hasNext()) {
                                imageioReader = it.next();
                                if (imageioReader != null) {
                                    imageioReader.setInput(inStream);
                                }
                            } else {
                                imageioReader = null;
                            }
                            if (imageioReader != null) break block43;
                            imageTypeSpecifier2 = null;
                            Object var8_10 = null;
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (Throwable e222222) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block44;
                                LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                            }
                        }
                        try {
                            if (imageioReader != null) {
                                imageioReader.dispose();
                            }
                        }
                        catch (Throwable e222222) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block45;
                            LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                        }
                    }
                    return imageTypeSpecifier2;
                }
                imageTypeSpecifier = its = imageioReader.getImageTypes(0).next();
                Object var8_11 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable e222222) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block46;
                    LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                }
            }
            try {
                if (imageioReader != null) {
                    imageioReader.dispose();
                }
            }
            catch (Throwable e222222) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block47;
                LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
            }
        }
        return imageTypeSpecifier;
        catch (IOException e) {
            ImageTypeSpecifier imageTypeSpecifier4;
            block49: {
                Throwable e222222;
                block48: {
                    imageTypeSpecifier4 = null;
                    Object var8_12 = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Throwable e222222) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block48;
                        LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                    }
                }
                try {
                    if (imageioReader != null) {
                        imageioReader.dispose();
                    }
                }
                catch (Throwable e222222) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block49;
                    LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                }
            }
            return imageTypeSpecifier4;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ImageTypeSpecifier imageTypeSpecifier5;
            block51: {
                Throwable e222222;
                block50: {
                    imageTypeSpecifier5 = null;
                    Object var8_13 = null;
                    {
                        catch (Throwable throwable) {
                            block53: {
                                Throwable e222222;
                                block52: {
                                    Object var8_14 = null;
                                    try {
                                        if (inStream != null) {
                                            inStream.close();
                                        }
                                    }
                                    catch (Throwable e222222) {
                                        if (!LOGGER.isLoggable(Level.FINEST)) break block52;
                                        LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                                    }
                                }
                                try {
                                    if (imageioReader != null) {
                                        imageioReader.dispose();
                                    }
                                }
                                catch (Throwable e222222) {
                                    if (!LOGGER.isLoggable(Level.FINEST)) break block53;
                                    LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Throwable e222222) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block50;
                        LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                    }
                }
                try {
                    if (imageioReader != null) {
                        imageioReader.dispose();
                    }
                }
                catch (Throwable e222222) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block51;
                    LOGGER.log(Level.FINEST, e222222.getLocalizedMessage(), e222222);
                }
            }
            return imageTypeSpecifier5;
        }
    }

    static URL checkURLForMosaicQuery(URL sourceURL) {
        block9: {
            String query;
            if (sourceURL.getProtocol().equalsIgnoreCase("file") && (query = sourceURL.getQuery()) != null) {
                String[] tokens = query.split("\\&");
                String locationPath = sourceURL.getPath();
                String indexName = null;
                File sourceDir = new File(locationPath);
                if (!(sourceDir.isDirectory() && sourceDir.exists() && sourceDir.canRead())) {
                    return null;
                }
                String wildcardString = null;
                boolean absolutePath = false;
                for (String token : tokens) {
                    String[] values = token.split("\\=");
                    if (values[0].equalsIgnoreCase("name")) {
                        indexName = values[1];
                        continue;
                    }
                    if (values[0].equalsIgnoreCase("w") || values[0].equalsIgnoreCase("wildcard")) {
                        wildcardString = values[1];
                        continue;
                    }
                    if (!values[0].equalsIgnoreCase("p") && !values[0].equalsIgnoreCase("path")) continue;
                    absolutePath = Boolean.parseBoolean(values[1]);
                }
                File shapeFile = new File(locationPath, indexName + ".shp");
                File propertiesFile = new File(locationPath, indexName + ".properties");
                if (!(shapeFile.exists() && shapeFile.canRead() && shapeFile.isFile() && propertiesFile.exists() && propertiesFile.canRead() && propertiesFile.isFile())) {
                    ImageMosaicUtils.createMosaic(locationPath, indexName != null ? indexName : FilenameUtils.getBaseName((String)locationPath), wildcardString != null ? wildcardString : DEFAULT_WILCARD, absolutePath);
                }
                if (!(shapeFile.exists() && shapeFile.canRead() && shapeFile.isFile() && propertiesFile.exists() && propertiesFile.canRead() && propertiesFile.isFile())) {
                    return null;
                }
                try {
                    return shapeFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block9;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        return sourceURL;
    }

    static MosaicConfigurationBean loadPropertiesFile(URL sourceURL, CoordinateReferenceSystem crs, String defaultLocationAttribute) {
        return ImageMosaicUtils.loadPropertiesFile(sourceURL, crs, defaultLocationAttribute, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static MosaicConfigurationBean loadPropertiesFile(URL sourceURL, CoordinateReferenceSystem crs, String defaultLocationAttribute, Set<String> ignorePropertiesSet) {
        InputStream openStream;
        Properties properties;
        boolean ignoreSome;
        MosaicConfigurationBean retValue;
        block32: {
            retValue = new MosaicConfigurationBean();
            ignoreSome = ignorePropertiesSet != null && !ignorePropertiesSet.isEmpty();
            properties = new Properties();
            URL propsURL = DataUtilities.changeUrlExt((URL)sourceURL, (String)"properties");
            BufferedInputStream stream = null;
            openStream = null;
            try {
                openStream = propsURL.openStream();
                stream = new BufferedInputStream(openStream);
                properties.load(stream);
                if (stream == null) break block32;
            }
            catch (FileNotFoundException e) {
                MosaicConfigurationBean mosaicConfigurationBean;
                block33: {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    mosaicConfigurationBean = null;
                    if (stream == null) break block33;
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                return mosaicConfigurationBean;
            }
            catch (IOException e2) {
                MosaicConfigurationBean mosaicConfigurationBean;
                block34: {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
                    }
                    mosaicConfigurationBean = null;
                    if (stream == null) break block34;
                    {
                        catch (Throwable throwable) {
                            if (stream != null) {
                                IOUtils.closeQuietly(stream);
                            }
                            if (openStream != null) {
                                IOUtils.closeQuietly((InputStream)openStream);
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                return mosaicConfigurationBean;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (openStream != null) {
            IOUtils.closeQuietly((InputStream)openStream);
        }
        String[] pairs = null;
        String[] pair = null;
        if (!ignoreSome && !properties.containsKey("Envelope2D") || ignoreSome && !ignorePropertiesSet.contains("Envelope2D") && !properties.containsKey("Envelope2D")) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Required key Envelope2D not found.");
            }
            return null;
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Envelope2D")) {
            String envelope = properties.getProperty("Envelope2D").trim();
            pairs = envelope.split(" ");
            double[][] cornersV = new double[2][2];
            for (int i = 0; i < 2; ++i) {
                pair = pairs[i].split(",");
                cornersV[i][0] = Double.parseDouble(pair[0]);
                cornersV[i][1] = Double.parseDouble(pair[1]);
            }
            GeneralEnvelope originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
            originalEnvelope.setCoordinateReferenceSystem(crs);
            retValue.setEnvelope2D(new Envelope2D(originalEnvelope));
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Levels")) {
            int levelsNumber = Integer.parseInt(properties.getProperty("LevelsNum", "1").trim());
            retValue.setLevelsNum(levelsNumber);
            if (!properties.containsKey("Levels")) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Required key Levels not found.");
                }
                return null;
            }
            String levels = properties.getProperty("Levels").trim();
            pairs = levels.split(" ");
            if (pairs == null || pairs.length != levelsNumber) {
                LOGGER.severe("Levels number is different from the provided number of levels resoltion.");
                return null;
            }
            double[][] resolutions = new double[levelsNumber][2];
            for (int i = 0; i < levelsNumber; ++i) {
                pair = pairs[i].split(",");
                if (pair == null || pair.length != 2) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("OverviewLevel number is different from the provided number of levels resoltion.");
                    }
                    return null;
                }
                resolutions[i][0] = Double.parseDouble(pair[0]);
                resolutions[i][1] = Double.parseDouble(pair[1]);
            }
            retValue.setLevels(resolutions);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("SuggestedSPI") || !properties.containsKey("SuggestedSPI"))) {
            String suggestedSPI = properties.getProperty("SuggestedSPI").trim();
            retValue.setSuggestedSPI(suggestedSPI);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Name")) {
            if (!properties.containsKey("Name")) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Required key Name not found.");
                }
                return null;
            }
            String coverageName = properties.getProperty("Name").trim();
            retValue.setName(coverageName);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("ExpandToRGB")) {
            boolean expandMe = Boolean.valueOf(properties.getProperty("ExpandToRGB", "false").trim());
            retValue.setExpandToRGB(expandMe);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AbsolutePath")) {
            boolean absolutePath = Boolean.parseBoolean(properties.getProperty("AbsolutePath", Boolean.toString(false)).trim());
            retValue.setAbsolutePath(absolutePath);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("FootprintManagement")) {
            boolean footprintManagement = Boolean.valueOf(properties.getProperty("FootprintManagement", "false").trim());
            retValue.setFootprintManagement(footprintManagement);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("LocationAttribute")) {
            retValue.setLocationAttribute(properties.getProperty("LocationAttribute", DEFAULT_LOCATION_ATTRIBUTE).trim());
        }
        return retValue;
    }

    static double getThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        Utilities.ensureNonNull((String)"GeographicBoundingBox", (Object)geographicBBox);
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), DefaultGeographicCRS.WGS84);
    }

    static RenderedImage makeColorTransparent(Color transparentColor, RenderedImage image) throws IllegalStateException {
        ImageWorker w = new ImageWorker(image);
        if (image.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            w.forceComponentColorModel();
        }
        return w.makeColorTransparent(transparentColor).getRenderedImage();
    }

    static ImageReadParam cloneImageReadParam(ImageReadParam param) {
        ImageReadParam newParam = new ImageReadParam();
        if (param.hasController()) {
            newParam.setController(param.getController());
        }
        newParam.setDestination(param.getDestination());
        if (param.getDestinationType() != null) {
            newParam.setDestinationType(param.getDestinationType());
        }
        newParam.setDestinationBands(param.getDestinationBands());
        newParam.setDestinationOffset(param.getDestinationOffset());
        newParam.setSourceBands(param.getSourceBands());
        newParam.setSourceRegion(param.getSourceRegion());
        if (param.getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
            newParam.setSourceProgressivePasses(param.getSourceMinProgressivePass(), param.getSourceNumProgressivePasses());
        }
        if (param.canSetSourceRenderSize()) {
            newParam.setSourceRenderSize(param.getSourceRenderSize());
        }
        newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
        return newParam;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static Rectangle getDimension(int imageIndex, ImageInputStream inStream, ImageReader reader) throws IOException {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format((int)79, (Object)imageIndex));
        }
        inStream.reset();
        reader.setInput(inStream);
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    public static ImageInputStream getInputStream(File file) throws IOException {
        ImageInputStream inStream = ImageIO.createImageInputStream(file);
        if (inStream == null) {
            return null;
        }
        return inStream;
    }

    static ImageInputStream getInputStream(URL url) throws IOException {
        ImageInputStream inStream = cachedStreamSPI.createInputStreamInstance(url, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
        if (inStream == null) {
            return null;
        }
        return inStream;
    }

    static boolean checkEmptySourceRegion(ImageReadParam readParameters, Rectangle dimensions) {
        Utilities.ensureNonNull((String)"readDimension", (Object)dimensions);
        Utilities.ensureNonNull((String)"readP", (Object)readParameters);
        Rectangle sourceRegion = readParameters.getSourceRegion();
        Rectangle.intersect(sourceRegion, dimensions, sourceRegion);
        if (sourceRegion.isEmpty()) {
            return true;
        }
        readParameters.setSourceRegion(sourceRegion);
        return false;
    }

    static boolean checkURLReadable(URL url) {
        try {
            url.openStream().close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeSampleImage(File sampleImageFile, SampleModel defaultSM, ColorModel defaultCM) throws IOException {
        SampleModel sm = defaultSM.createCompatibleSampleModel(1, 1);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
        BufferedImage sampleImage = new BufferedImage(defaultCM, raster, false, null);
        BufferedOutputStream outStream = null;
        ObjectOutputStream ooStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(sampleImageFile));
            ooStream = new ObjectOutputStream(outStream);
            ooStream.writeObject(new SerializableRenderedImage((RenderedImage)sampleImage));
        }
        finally {
            try {
                if (ooStream != null) {
                    ooStream.close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)ooStream);
            }
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
        }
    }

    static Number[] getBackgroundValues(SampleModel sampleModel, double[] backgroundValues) {
        Number[] values = null;
        int dataType = sampleModel != null ? sampleModel.getDataType() : 5;
        int numBands = sampleModel.getNumBands();
        switch (dataType) {
            case 0: {
                values = new Byte[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = i >= backgroundValues.length ? Byte.valueOf((byte)backgroundValues[0]) : Byte.valueOf((byte)backgroundValues[i]);
                    }
                    break;
                }
            }
            case 1: 
            case 2: {
                values = new Short[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                } else {
                    values = new Short[backgroundValues.length];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = i >= backgroundValues.length ? Short.valueOf((short)backgroundValues[0]) : Short.valueOf((short)backgroundValues[i]);
                    }
                    break;
                }
            }
            case 3: {
                values = new Integer[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = i >= backgroundValues.length ? Integer.valueOf((int)backgroundValues[0]) : Integer.valueOf((int)backgroundValues[i]);
                    }
                    break;
                }
            }
            case 4: {
                values = new Float[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, Float.valueOf(0.0f));
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = i >= backgroundValues.length ? Float.valueOf((float)backgroundValues[0]) : Float.valueOf((float)backgroundValues[i]);
                    }
                    break;
                }
            }
            case 5: {
                values = new Double[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0.0);
                    break;
                }
                values = new Double[backgroundValues.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Double.valueOf(backgroundValues[0]) : Double.valueOf(backgroundValues[i]);
                }
                break;
            }
        }
        return values;
    }

    static final class MosaicConfigurationBean {
        private boolean absolutePath;
        private boolean expandToRGB;
        private boolean footprintManagement;
        private Envelope2D envelope2D;
        private double[][] levels;
        private String name;
        private int levelsNum;
        private String locationAttribute;
        private String suggestedSPI;

        MosaicConfigurationBean() {
        }

        public String getSuggestedSPI() {
            return this.suggestedSPI;
        }

        public void setSuggestedSPI(String suggestedSPI) {
            this.suggestedSPI = suggestedSPI;
        }

        public boolean isAbsolutePath() {
            return this.absolutePath;
        }

        public void setAbsolutePath(boolean absolutePath) {
            this.absolutePath = absolutePath;
        }

        public boolean isExpandToRGB() {
            return this.expandToRGB;
        }

        public void setExpandToRGB(boolean expandToRGB) {
            this.expandToRGB = expandToRGB;
        }

        public boolean isFootprintManagement() {
            return this.footprintManagement;
        }

        public void setFootprintManagement(boolean footprintManagement) {
            this.footprintManagement = footprintManagement;
        }

        public Envelope2D getEnvelope2D() {
            return this.envelope2D;
        }

        public void setEnvelope2D(Envelope2D envelope2D) {
            this.envelope2D = envelope2D;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLevelsNum() {
            return this.levelsNum;
        }

        public void setLevelsNum(int levelsNum) {
            this.levelsNum = levelsNum;
        }

        public double[][] getLevels() {
            return (double[][])this.levels.clone();
        }

        public void setLevels(double[][] levels) {
            this.levels = (double[][])levels.clone();
        }

        public String getLocationAttribute() {
            return this.locationAttribute;
        }

        public void setLocationAttribute(String locationAttribute) {
            this.locationAttribute = locationAttribute;
        }
    }

    static class Prop {
        static final String LOCATION_ATTRIBUTE = "LocationAttribute";
        static final String ENVELOPE2D = "Envelope2D";
        static final String LEVELS_NUM = "LevelsNum";
        static final String LEVELS = "Levels";
        static final String SUGGESTED_SPI = "SuggestedSPI";
        static final String EXP_RGB = "ExpandToRGB";
        static final String ABSOLUTE_PATH = "AbsolutePath";
        static final String NAME = "Name";
        static final String FOOTPRINT_MANAGEMENT = "FootprintManagement";

        Prop() {
        }
    }
}

