/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.util.Map;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractGridFormat
implements Format {
    protected Map<String, String> mInfo;
    protected ParameterValueGroup readParameters;
    protected ParameterValueGroup writeParameters;
    private static CoordinateReferenceSystem crs;
    public static final DefaultParameterDescriptor<GridGeometry2D> READ_GRIDGEOMETRY2D;
    public static final DefaultParameterDescriptor<GeoToolsWriteParams> GEOTOOLS_WRITE_PARAMS;
    public static final DefaultParameterDescriptor<Boolean> USE_JAI_IMAGEREAD;
    public static final DefaultParameterDescriptor<OverviewPolicy> OVERVIEW_POLICY;

    public String getName() {
        return this.mInfo.get("name");
    }

    public String getDescription() {
        return this.mInfo.get("description");
    }

    public String getVendor() {
        return this.mInfo.get("vendor");
    }

    public String getDocURL() {
        return this.mInfo.get("docURL");
    }

    public String getVersion() {
        return this.mInfo.get("version");
    }

    public abstract AbstractGridCoverage2DReader getReader(Object var1);

    public abstract AbstractGridCoverage2DReader getReader(Object var1, Hints var2);

    public abstract GridCoverageWriter getWriter(Object var1);

    public abstract boolean accepts(Object var1);

    public boolean equals(Format f) {
        return f.getClass() == this.getClass();
    }

    public ParameterValueGroup getReadParameters() {
        if (this.readParameters == null) {
            throw new UnsupportedOperationException("This format does not support usage of read parameters.");
        }
        return this.readParameters.clone();
    }

    public ParameterValueGroup getWriteParameters() {
        if (this.writeParameters == null) {
            throw new UnsupportedOperationException("This format does not support usage of write parameters.");
        }
        return this.writeParameters.clone();
    }

    public static CoordinateReferenceSystem getDefaultCRS() {
        return crs;
    }

    public abstract GeoToolsWriteParams getDefaultImageIOWriteParameters();

    static {
        try {
            crs = CRS.decode("EPSG:4326", true);
        }
        catch (NoSuchAuthorityCodeException e) {
            crs = DefaultGeographicCRS.WGS84;
        }
        catch (FactoryException e) {
            crs = DefaultGeographicCRS.WGS84;
        }
        READ_GRIDGEOMETRY2D = new DefaultParameterDescriptor<Object>("ReadGridGeometry2D", GridGeometry2D.class, null, null);
        GEOTOOLS_WRITE_PARAMS = new DefaultParameterDescriptor<Object>("WriteParameters", GeoToolsWriteParams.class, null, null);
        USE_JAI_IMAGEREAD = new DefaultParameterDescriptor<Boolean>(Hints.USE_JAI_IMAGEREAD.toString(), Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.TRUE);
        OVERVIEW_POLICY = new DefaultParameterDescriptor<OverviewPolicy>(Hints.OVERVIEW_POLICY.toString(), OverviewPolicy.class, new OverviewPolicy[]{OverviewPolicy.IGNORE, OverviewPolicy.NEAREST, OverviewPolicy.QUALITY, OverviewPolicy.SPEED}, OverviewPolicy.QUALITY);
    }
}

