/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.processing.operation.CroppedCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.Coverage;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Crop
extends Operation2D {
    private static final long serialVersionUID = 4466072819239413456L;
    public static final ParameterDescriptor<Envelope> CROP_ENVELOPE = new DefaultParameterDescriptor<Object>(Citations.GEOTOOLS, "Envelope", Envelope.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<Double> ROI_OPTIMISATION_TOLERANCE = new DefaultParameterDescriptor<Double>(Citations.GEOTOOLS, "ROITolerance", Double.class, null, 0.6, Double.valueOf(0.0), Double.valueOf(1.0), null, true);
    public static final ParameterDescriptor<Boolean> CONSERVE_ENVELOPE = new DefaultParameterDescriptor<Boolean>(Citations.GEOTOOLS, "ConserveEnvelope", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE, null, null, null, true);

    public Crop() {
        super(new DefaultParameterDescriptorGroup(Citations.GEOTOOLS, "CoverageCrop", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, CROP_ENVELOPE, CONSERVE_ENVELOPE, ROI_OPTIMISATION_TOLERANCE}));
    }

    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        ParameterValue sourceParameter = parameters.parameter("Source");
        if (sourceParameter == null || !(sourceParameter.getValue() instanceof GridCoverage2D)) {
            throw new CannotCropException(Errors.format((int)146, (Object)"Source", (Object)GridCoverage2D.class.toString()));
        }
        ParameterValue envelopeParameter = parameters.parameter("Envelope");
        if (envelopeParameter == null || !(envelopeParameter.getValue() instanceof Envelope)) {
            throw new CannotCropException(Errors.format((int)146, (Object)"Envelope", (Object)GeneralEnvelope.class.toString()));
        }
        ParameterValue conserveEnvelopeParameter = parameters.parameter("ConserveEnvelope");
        if (conserveEnvelopeParameter == null || !(conserveEnvelopeParameter.getValue() instanceof Boolean)) {
            throw new CannotCropException(Errors.format((int)146, (Object)"ConserveEnvelope", (Object)Double.class.toString()));
        }
        GridCoverage2D source = (GridCoverage2D)sourceParameter.getValue();
        Envelope2D sourceEnvelope = source.getEnvelope2D();
        Envelope2D destinationEnvelope = new Envelope2D((Envelope)envelopeParameter.getValue());
        CoordinateReferenceSystem sourceCRS = sourceEnvelope.getCoordinateReferenceSystem();
        CoordinateReferenceSystem destinationCRS = destinationEnvelope.getCoordinateReferenceSystem();
        if (destinationCRS == null) {
            Envelope2D ge = new Envelope2D(destinationEnvelope);
            destinationCRS = source.getCoordinateReferenceSystem2D();
            ge.setCoordinateReferenceSystem(destinationCRS);
            destinationEnvelope = ge;
        }
        if (!CRS.equalsIgnoreMetadata(sourceCRS, destinationCRS)) {
            throw new CannotCropException(Errors.format((int)95, (Object)sourceCRS.getName().getCode(), (Object)destinationCRS.getName().getCode()));
        }
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope(destinationEnvelope);
        intersectionEnvelope.setCoordinateReferenceSystem(source.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect(sourceEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            throw new CannotCropException(Errors.format((int)25));
        }
        AffineTransform sourceGridToWorld = (AffineTransform)source.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        double tolerance = XAffineTransform.getScale(sourceGridToWorld);
        if (!intersectionEnvelope.equals(sourceEnvelope, tolerance / 2.0, false)) {
            envelopeParameter.setValue((Object)intersectionEnvelope.clone());
            return CroppedCoverage2D.create(parameters, hints instanceof Hints ? hints : new Hints((RenderingHints)hints), source, sourceGridToWorld, tolerance);
        }
        return source;
    }

    static double area(Point2D[] polyPoints) {
        int n = polyPoints.length;
        double area = 0.0;
        for (int i = 0; i < n; ++i) {
            int j = (i + 1) % n;
            area += polyPoints[i].getX() * polyPoints[j].getY();
            area -= polyPoints[j].getX() * polyPoints[i].getY();
        }
        return area /= 2.0;
    }
}

