/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.RenderingHints;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Association;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AssociationDescriptor;
import org.opengis.feature.type.AssociationType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    protected static final Logger LOGGER = Logging.getLogger(JDBCFeatureReader.class);
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.jdbc.trace"));
    protected JDBCFeatureSource featureSource;
    protected JDBCDataStore dataStore;
    protected SimpleFeatureType featureType;
    protected GeometryFactory geometryFactory;
    protected Hints hints;
    protected Transaction tx;
    protected Boolean next;
    protected SimpleFeatureBuilder builder;
    protected PrimaryKey pkey;
    protected Statement st;
    protected ResultSet rs;
    protected Connection cx;
    protected Exception tracer;
    protected String[] columnNames;

    public JDBCFeatureReader(String sql, Connection cx, JDBCFeatureSource featureSource, SimpleFeatureType featureType, Hints hints) throws SQLException {
        this.init(featureSource, featureType, hints);
        this.cx = cx;
        this.st = cx.createStatement(1003, 1007);
        this.st.setFetchSize(featureSource.getDataStore().getFetchSize());
        this.rs = this.st.executeQuery(sql);
    }

    public JDBCFeatureReader(PreparedStatement st, Connection cx, JDBCFeatureSource featureSource, SimpleFeatureType featureType, Hints hints) throws SQLException {
        this.init(featureSource, featureType, hints);
        this.cx = cx;
        this.st = st;
        this.rs = st.executeQuery();
    }

    protected void init(JDBCFeatureSource featureSource, SimpleFeatureType featureType, Hints hints) {
        FeatureFactory ff;
        CoordinateSequenceFactory csFactory;
        if (TRACE_ENABLED.booleanValue()) {
            this.tracer = new Exception();
            this.tracer.fillInStackTrace();
        }
        this.featureSource = featureSource;
        this.dataStore = featureSource.getDataStore();
        this.featureType = featureType;
        this.tx = featureSource.getTransaction();
        this.hints = hints;
        this.geometryFactory = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (this.geometryFactory == null && (csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) != null) {
            this.geometryFactory = new GeometryFactory(csFactory);
        }
        if (this.geometryFactory == null) {
            this.geometryFactory = this.dataStore.getGeometryFactory();
        }
        if ((ff = (FeatureFactory)hints.get((Object)Hints.FEATURE_FACTORY)) == null) {
            ff = featureSource.getDataStore().getFeatureFactory();
        }
        this.builder = new SimpleFeatureBuilder(featureType, ff);
        try {
            this.pkey = this.dataStore.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JDBCFeatureReader(JDBCFeatureReader other) {
        this.featureType = other.featureType;
        this.dataStore = other.dataStore;
        this.featureSource = other.featureSource;
        this.tx = other.tx;
        this.hints = other.hints;
        this.geometryFactory = other.geometryFactory;
        this.builder = other.builder;
        this.st = other.st;
        this.rs = other.rs;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public boolean hasNext() throws IOException {
        this.ensureOpen();
        if (this.next == null) {
            try {
                this.next = this.rs.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.next;
    }

    protected void ensureNext() {
        if (this.next == null) {
            throw new IllegalStateException("Must call hasNext before calling next");
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.rs == null) {
            throw new IOException("reader already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        try {
            String fid;
            Connection cx;
            this.ensureOpen();
            this.ensureNext();
            try {
                cx = this.st.getConnection();
            }
            catch (SQLException e) {
                throw (IOException)new IOException().initCause(e);
            }
            try {
                fid = this.dataStore.encodeFID(this.pkey, this.rs);
                fid = this.featureType.getTypeName() + "." + fid;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not determine fid from primary key", e);
            }
            Integer depth = (Integer)this.hints.get((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH);
            if (depth == null) {
                depth = new Integer(0);
            }
            PropertyName associationPropertyName = (PropertyName)this.hints.get((Object)Hints.ASSOCIATION_PROPERTY);
            int attributeCount = this.featureType.getAttributeCount();
            int[] attributeRsIndex = this.buildAttributeRsIndex();
            for (int i = 0; i < attributeCount; ++i) {
                boolean resolve;
                AttributeDescriptor type = this.featureType.getDescriptor(i);
                boolean bl = resolve = depth > 0;
                if (resolve && associationPropertyName != null) {
                    AttributeDescriptor associationProperty = (AttributeDescriptor)associationPropertyName.evaluate((Object)this.featureType);
                    resolve = associationProperty != null && associationProperty.getLocalName().equals(type.getLocalName());
                }
                try {
                    Class binding;
                    Object converted;
                    Object value;
                    block75: {
                        value = null;
                        if (type instanceof GeometryDescriptor) {
                            GeometryDescriptor gatt = (GeometryDescriptor)type;
                            try {
                                value = this.dataStore.getSQLDialect().decodeGeometryValue(gatt, this.rs, attributeRsIndex[i], this.geometryFactory, cx);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            if (value != null) {
                                Geometry geometry = (Geometry)value;
                                if (geometry.getUserData() == null) {
                                    geometry.setUserData(gatt.getCoordinateReferenceSystem());
                                }
                            } else if (this.dataStore.isAssociations()) {
                                try {
                                    this.dataStore.ensureAssociationTablesExist(this.st.getConnection());
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                Statement select = null;
                                ResultSet gas = null;
                                try {
                                    if (this.dataStore.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                                        select = this.dataStore.selectGeometryAssociationSQLPS(fid, null, gatt.getLocalName(), cx);
                                        gas = select.executeQuery();
                                    } else {
                                        String sql = this.dataStore.selectGeometryAssociationSQL(fid, null, gatt.getLocalName());
                                        this.dataStore.getLogger().fine(sql);
                                        select = this.st.getConnection().createStatement();
                                        gas = select.executeQuery(sql.toString());
                                    }
                                    if (gas.next()) {
                                        String gid = gas.getString("gid");
                                        boolean ref = gas.getBoolean("ref");
                                        Geometry g = null;
                                        if (ref && !resolve) {
                                            g = this.geometryFactory.createPoint(new CoordinateArraySequence(new Coordinate[0]));
                                            this.dataStore.setGmlProperties(g, gid, null, null);
                                        } else {
                                            ResultSet grs = null;
                                            if (this.dataStore.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                                                this.dataStore.closeSafe(select);
                                                select = this.dataStore.selectGeometrySQLPS(gid, cx);
                                                grs = ((PreparedStatement)select).executeQuery();
                                            } else {
                                                String sql = this.dataStore.selectGeometrySQL(gid);
                                                this.dataStore.getLogger().fine(sql);
                                                grs = select.executeQuery(sql);
                                            }
                                            try {
                                                if (!grs.next()) {
                                                    throw new SQLException("no entry for: " + gid + " in " + "geometry");
                                                }
                                                String name = grs.getString("name");
                                                String desc = grs.getString("description");
                                                if (grs.getObject("geometry") != null) {
                                                    g = this.dataStore.getSQLDialect().decodeGeometryValue(gatt, grs, "geometry", this.geometryFactory, cx);
                                                } else {
                                                    String gtype = grs.getString("type");
                                                    if ("MULTIPOINT".equals(gtype) || "MULTILINESTRING".equals(gtype) || "MULTIPOLYGON".equals(gtype)) {
                                                        ResultSet mg = null;
                                                        if (this.dataStore.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                                                            this.dataStore.closeSafe(select);
                                                            select = this.dataStore.selectMultiGeometrySQLPS(gid, cx);
                                                            mg = ((PreparedStatement)select).executeQuery();
                                                        } else {
                                                            String sql = this.dataStore.selectMultiGeometrySQL(gid);
                                                            this.dataStore.getLogger().fine(sql);
                                                            mg = select.executeQuery(sql);
                                                        }
                                                        try {
                                                            ArrayList<Point> members = new ArrayList<Point>();
                                                            while (mg.next()) {
                                                                String mgid = mg.getString("mgid");
                                                                boolean mref = mg.getBoolean("ref");
                                                                Geometry member = null;
                                                                if (!mref || resolve) {
                                                                    Statement select2 = null;
                                                                    ResultSet mgg = null;
                                                                    if (this.dataStore.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                                                                        select2 = this.dataStore.selectGeometrySQLPS(mgid, cx);
                                                                        mgg = select2.executeQuery();
                                                                    } else {
                                                                        String sql = this.dataStore.selectGeometrySQL(mgid);
                                                                        this.dataStore.getLogger().fine(sql);
                                                                        select2 = this.st.getConnection().createStatement();
                                                                        mgg = select2.executeQuery(sql);
                                                                    }
                                                                    try {
                                                                        mgg.next();
                                                                        String mname = mgg.getString("name");
                                                                        String mdesc = mgg.getString("description");
                                                                        member = this.dataStore.getSQLDialect().decodeGeometryValue(gatt, mgg, "geometry", this.geometryFactory, cx);
                                                                        this.dataStore.setGmlProperties(member, mgid, mname, mdesc);
                                                                    }
                                                                    finally {
                                                                        this.dataStore.closeSafe(mgg);
                                                                        this.dataStore.closeSafe(select2);
                                                                    }
                                                                } else {
                                                                    member = this.geometryFactory.createPoint(new CoordinateArraySequence(new Coordinate[0]));
                                                                    this.dataStore.setGmlProperties(member, mgid, null, null);
                                                                }
                                                                members.add((Point)member);
                                                            }
                                                            g = "MULTIPOINT".equals(gtype) ? this.geometryFactory.createMultiPoint(members.toArray(new Point[members.size()])) : ("MULTILINESTRING".equals(gtype) ? this.geometryFactory.createMultiLineString(members.toArray(new LineString[members.size()])) : ("MULTIPOLYGON".equals(gtype) ? this.geometryFactory.createMultiPolygon(members.toArray(new Polygon[members.size()])) : this.geometryFactory.createGeometryCollection(members.toArray(new Geometry[members.size()]))));
                                                        }
                                                        finally {
                                                            this.dataStore.closeSafe(mg);
                                                        }
                                                    }
                                                }
                                                this.dataStore.setGmlProperties(g, gid, name, desc);
                                            }
                                            catch (IOException e) {
                                                throw new RuntimeException(e);
                                            }
                                            finally {
                                                this.dataStore.closeSafe(grs);
                                            }
                                        }
                                        value = g;
                                    }
                                    this.dataStore.closeSafe(gas);
                                    this.dataStore.closeSafe(select);
                                }
                                catch (Throwable throwable) {
                                    this.dataStore.closeSafe(gas);
                                    this.dataStore.closeSafe(select);
                                    throw throwable;
                                }
                            }
                        } else {
                            value = this.rs.getObject(attributeRsIndex[i]);
                        }
                        if (this.dataStore.isAssociations() && Association.class.equals((Object)type.getType().getBinding()) && value != null) {
                            Statement select = null;
                            ResultSet associations = null;
                            if (this.dataStore.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                                select = this.dataStore.selectAssociationSQLPS(fid, cx);
                                associations = select.executeQuery();
                            } else {
                                String sql = this.dataStore.selectAssociationSQL(fid);
                                this.dataStore.getLogger().fine(sql);
                                select = this.st.getConnection().createStatement();
                                associations = select.executeQuery(sql);
                            }
                            try {
                                if (!associations.next()) break block75;
                                String rtable = associations.getString("rtable");
                                String rfid = associations.getString("rfid");
                                SimpleFeatureType associatedType = null;
                                try {
                                    associatedType = this.dataStore.getSchema(rtable);
                                }
                                catch (IOException e) {
                                    String msg = "Could not load schema: " + rtable;
                                    this.dataStore.getLogger().log(Level.WARNING, msg, e);
                                }
                                this.builder.userData((Object)"gml:id", (Object)(rtable + "." + rfid));
                                this.builder.userData((Object)"gml:featureTypeName", (Object)rtable);
                                FeatureTypeFactory tf = this.dataStore.getFeatureTypeFactory();
                                if (associatedType == null) {
                                    SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder(tf);
                                    tb.setName(rtable);
                                    associatedType = tb.buildFeatureType();
                                }
                                AssociationType associationType = tf.createAssociationType(type.getName(), (AttributeType)associatedType, false, Collections.EMPTY_LIST, null, null);
                                AssociationDescriptor associationDescriptor = tf.createAssociationDescriptor(associationType, type.getName(), 1, 1, true);
                                FeatureFactory f = this.dataStore.getFeatureFactory();
                                Association association = f.createAssociation(null, associationDescriptor);
                                association.getUserData().put("gml:id", rtable + "." + rfid);
                                if (resolve) {
                                    DefaultQuery query = new DefaultQuery(rtable);
                                    Hints hints = new Hints((RenderingHints.Key)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)new Integer(depth - 1));
                                    query.setHints(hints);
                                    FilterFactory ff = this.dataStore.getFilterFactory();
                                    Id filter = ff.id(Collections.singleton(ff.featureId(value.toString())));
                                    query.setFilter((Filter)filter);
                                    try {
                                        FeatureReader r = this.dataStore.getFeatureReader((Query)query, this.tx);
                                        try {
                                            r.hasNext();
                                            SimpleFeature associated = (SimpleFeature)r.next();
                                            association.setValue((Object)associated);
                                        }
                                        finally {
                                            r.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                value = association;
                            }
                            finally {
                                this.dataStore.closeSafe(associations);
                                this.dataStore.closeSafe(select);
                            }
                        }
                    }
                    if (value != null && (converted = Converters.convert(value, binding = type.getType().getBinding())) != null && converted != value) {
                        value = converted;
                        if (this.dataStore.getLogger().isLoggable(Level.FINER)) {
                            String msg = value + " is not of type " + binding.getName() + ", attempting conversion";
                            this.dataStore.getLogger().finer(msg);
                        }
                    }
                    this.builder.add(value);
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                SimpleFeature i = this.builder.buildFeature(fid);
                return i;
            }
            catch (IllegalAttributeException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        finally {
            this.next = null;
        }
    }

    private int[] buildAttributeRsIndex() {
        LinkedHashSet<String> pkColumns = this.dataStore.getColumnNames(this.pkey);
        ArrayList<String> pkColumnsList = new ArrayList<String>(pkColumns);
        int[] indexes = new int[this.featureType.getAttributeCount()];
        int exposedPks = 0;
        for (int i = 0; i < indexes.length; ++i) {
            String attName = this.featureType.getDescriptor(i).getLocalName();
            if (pkColumns.contains(attName)) {
                indexes[i] = pkColumnsList.indexOf(attName) + 1;
                ++exposedPks;
                continue;
            }
            indexes[i] = i + pkColumns.size() - exposedPks + 1;
        }
        return indexes;
    }

    @Override
    public void close() throws IOException {
        if (this.dataStore != null) {
            this.dataStore.closeSafe(this.rs);
            this.dataStore.closeSafe(this.st);
            this.dataStore.releaseConnection(this.cx, this.featureSource.getState());
        }
        this.cleanup();
    }

    protected void cleanup() {
        this.rs = null;
        this.st = null;
        this.dataStore = null;
        this.featureSource = null;
        this.featureType = null;
        this.geometryFactory = null;
        this.tx = null;
        this.hints = null;
        this.next = null;
        this.builder = null;
        this.tracer = null;
    }

    protected void finalize() throws Throwable {
        if (this.dataStore != null) {
            LOGGER.warning("There is code leaving feature readers/iterators open, this is leaking statements and connections!");
            if (TRACE_ENABLED.booleanValue()) {
                LOGGER.log(Level.WARNING, "The unclosed reader originated on this stack trace", this.tracer);
            }
            this.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResultSetFeature
    implements SimpleFeature {
        ResultSet rs;
        Connection cx;
        PrimaryKey key;
        Object[] values;
        FeatureId fid;
        boolean[] dirty;
        boolean newFeature;
        HashMap<String, Integer> index;
        HashMap<Object, Object> userData = new HashMap();
        boolean exposePrimaryKeys;

        ResultSetFeature(ResultSet rs, Connection cx) throws SQLException, IOException {
            this.rs = rs;
            this.cx = cx;
            ResultSetMetaData md = rs.getMetaData();
            this.key = JDBCFeatureReader.this.dataStore.getPrimaryKey(JDBCFeatureReader.this.featureType);
            int count = md.getColumnCount();
            JDBCFeatureReader.this.columnNames = new String[count];
            this.exposePrimaryKeys = JDBCFeatureReader.this.featureSource.getState().isExposePrimaryKeyColumns();
            block0: for (int i = 0; i < md.getColumnCount(); ++i) {
                String columnName;
                JDBCFeatureReader.this.columnNames[i] = columnName = md.getColumnName(i + 1);
                if (this.exposePrimaryKeys) continue;
                for (PrimaryKeyColumn col : this.key.getColumns()) {
                    if (!col.getName().equals(columnName)) continue;
                    --count;
                    continue block0;
                }
            }
            this.values = new Object[count];
            this.dirty = new boolean[this.values.length];
            this.index = new HashMap();
            int offset = 0;
            block2: for (int i = 0; i < md.getColumnCount(); ++i) {
                if (!this.exposePrimaryKeys) {
                    for (PrimaryKeyColumn col : this.key.getColumns()) {
                        if (!col.getName().equals(md.getColumnName(i + 1))) continue;
                        ++offset;
                        continue block2;
                    }
                }
                this.index.put(md.getColumnName(i + 1), i - offset);
            }
        }

        public void init(String fid) {
            this.newFeature = fid == null;
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = null;
                this.dirty[i] = false;
            }
            this.fid = SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)fid);
        }

        public void init() throws SQLException, IOException {
            this.init(JDBCFeatureReader.this.featureType.getTypeName() + "." + JDBCFeatureReader.this.dataStore.encodeFID(this.key, this.rs));
        }

        public SimpleFeatureType getFeatureType() {
            return JDBCFeatureReader.this.featureType;
        }

        public SimpleFeatureType getType() {
            return JDBCFeatureReader.this.featureType;
        }

        public FeatureId getIdentifier() {
            return this.fid;
        }

        public String getID() {
            return this.fid.getID();
        }

        public void setID(String id) {
            ((FeatureIdImpl)this.fid).setID(id);
        }

        public Object getAttribute(String name) {
            return this.getAttribute(this.index.get(name));
        }

        public Object getAttribute(Name name) {
            return this.getAttribute(name.getLocalPart());
        }

        public Object getAttribute(int index) throws IndexOutOfBoundsException {
            return this.getAttributeInternal(index, this.mapToResultSetIndex(index));
        }

        private int mapToResultSetIndex(int index) {
            int rsindex = index;
            block0: for (int i = 0; i <= index; ++i) {
                if (this.exposePrimaryKeys) continue;
                for (PrimaryKeyColumn col : this.key.getColumns()) {
                    if (!col.getName().equals(JDBCFeatureReader.this.columnNames[i])) continue;
                    ++rsindex;
                    continue block0;
                }
            }
            return ++rsindex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getAttributeInternal(int index, int rsindex) {
            if (!this.newFeature && this.values[index] == null && !this.dirty[index]) {
                ResultSetFeature resultSetFeature = this;
                synchronized (resultSetFeature) {
                    try {
                        if (!this.newFeature && this.values[index] == null && !this.dirty[index]) {
                            AttributeDescriptor att = JDBCFeatureReader.this.featureType.getDescriptor(index);
                            if (att instanceof GeometryDescriptor) {
                                GeometryDescriptor gatt = (GeometryDescriptor)att;
                                this.values[index] = JDBCFeatureReader.this.dataStore.getSQLDialect().decodeGeometryValue(gatt, this.rs, rsindex, JDBCFeatureReader.this.dataStore.getGeometryFactory(), JDBCFeatureReader.this.st.getConnection());
                            } else {
                                this.values[index] = this.rs.getObject(rsindex);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (SQLException e) {
                        this.values[index] = null;
                    }
                }
            }
            return this.values[index];
        }

        public void setAttribute(String name, Object value) {
            JDBCFeatureReader.this.dataStore.getLogger().fine("Setting " + name + " to " + value);
            int i = this.index.get(name);
            this.setAttribute(i, value);
        }

        public void setAttribute(Name name, Object value) {
            this.setAttribute(name.getLocalPart(), value);
        }

        public void setAttribute(int index, Object value) throws IndexOutOfBoundsException {
            JDBCFeatureReader.this.dataStore.getLogger().fine("Setting " + index + " to " + value);
            this.values[index] = value;
            this.dirty[index] = true;
        }

        public void setAttributes(List<Object> values) {
            for (int i = 0; i < values.size(); ++i) {
                this.setAttribute(i, values.get(i));
            }
        }

        public int getAttributeCount() {
            return this.values.length;
        }

        public boolean isDirty(int index) {
            return this.dirty[index];
        }

        public boolean isDirrty(String name) {
            return this.isDirty(this.index.get(name));
        }

        public void close() {
            this.rs = null;
            this.cx = null;
            JDBCFeatureReader.this.columnNames = null;
        }

        public List<Object> getAttributes() {
            throw new UnsupportedOperationException();
        }

        public Object getDefaultGeometry() {
            GeometryDescriptor defaultGeometry = JDBCFeatureReader.this.featureType.getGeometryDescriptor();
            return defaultGeometry != null ? this.getAttribute(defaultGeometry.getName()) : null;
        }

        public void setAttributes(Object[] object) {
            throw new UnsupportedOperationException();
        }

        public void setDefaultGeometry(Object defaultGeometry) {
            GeometryDescriptor descriptor = JDBCFeatureReader.this.featureType.getGeometryDescriptor();
            this.setAttribute(descriptor.getName(), defaultGeometry);
        }

        public BoundingBox getBounds() {
            Object obj = this.getDefaultGeometry();
            if (obj instanceof Geometry) {
                Geometry geometry = (Geometry)obj;
                return new ReferencedEnvelope(geometry.getEnvelopeInternal(), JDBCFeatureReader.this.featureType.getCoordinateReferenceSystem());
            }
            return new ReferencedEnvelope(JDBCFeatureReader.this.featureType.getCoordinateReferenceSystem());
        }

        public GeometryAttribute getDefaultGeometryProperty() {
            throw new UnsupportedOperationException();
        }

        public void setDefaultGeometryProperty(GeometryAttribute defaultGeometry) {
            throw new UnsupportedOperationException();
        }

        public Collection<Property> getProperties() {
            throw new UnsupportedOperationException();
        }

        public Collection<Property> getProperties(Name name) {
            throw new UnsupportedOperationException();
        }

        public Collection<Property> getProperties(String name) {
            throw new UnsupportedOperationException();
        }

        public Property getProperty(Name name) {
            throw new UnsupportedOperationException();
        }

        public Property getProperty(String name) {
            throw new UnsupportedOperationException();
        }

        public Collection<? extends Property> getValue() {
            throw new UnsupportedOperationException();
        }

        public void setValue(Collection<Property> value) {
            throw new UnsupportedOperationException();
        }

        public AttributeDescriptor getDescriptor() {
            throw new UnsupportedOperationException();
        }

        public Name getName() {
            throw new UnsupportedOperationException();
        }

        public Map<Object, Object> getUserData() {
            return this.userData;
        }

        public boolean isNillable() {
            throw new UnsupportedOperationException();
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public void validate() {
        }
    }
}

