/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.geotiff.adapters.GeoTiffIIOMetadataDecoder;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;

public final class GeoTiffFormat
extends AbstractGridFormat
implements Format {
    private static final TIFFImageReaderSpi spi = new TIFFImageReaderSpi();
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.geotiff");

    public GeoTiffFormat() {
        this.writeParameters = null;
        this.mInfo = new HashMap();
        this.mInfo.put("name", "GeoTIFF");
        this.mInfo.put("description", "Tagged Image File Format with Geographic information");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("version", "1.1");
        this.mInfo.put("docURL", "http://www.remotesensing.org/geotiff/spec/geotiffhome.html");
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{AbstractGridFormat.GEOTOOLS_WRITE_PARAMS}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean accepts(Object o) {
        block74: {
            boolean closeMe;
            ImageInputStream inputStream;
            ImageReader reader;
            block72: {
                boolean t22222222222222222222;
                block73: {
                    GeoTiffIIOMetadataDecoder metadataAdapter;
                    block70: {
                        boolean t22222222222222222222;
                        block71: {
                            IIOMetadata metadata;
                            block68: {
                                boolean t32222222222;
                                block69: {
                                    block66: {
                                        boolean url22222222222222222222;
                                        block67: {
                                            block64: {
                                                boolean url22222222222222222222;
                                                block65: {
                                                    if (o == null) {
                                                        return false;
                                                    }
                                                    reader = null;
                                                    inputStream = null;
                                                    closeMe = false;
                                                    if (o instanceof URL) {
                                                        URL url22222222222222222222 = (URL)o;
                                                        o = DataUtilities.urlToFile(url22222222222222222222);
                                                    } else if (o instanceof ImageInputStream) {
                                                        closeMe = false;
                                                    }
                                                    inputStream = (ImageInputStream)(o instanceof ImageInputStream ? o : ImageIO.createImageInputStream(o));
                                                    if (inputStream != null) break block64;
                                                    if (LOGGER.isLoggable(Level.FINE)) {
                                                        LOGGER.fine("Unable to get an ImageInputStream");
                                                    }
                                                    url22222222222222222222 = false;
                                                    if (reader == null) break block65;
                                                    try {
                                                        reader.dispose();
                                                    }
                                                    catch (Exception e) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (closeMe && inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    }
                                                    catch (Throwable t4) {
                                                        // empty catch block
                                                    }
                                                }
                                                return url22222222222222222222;
                                            }
                                            if (spi.canDecodeInput((Object)inputStream)) break block66;
                                            url22222222222222222222 = false;
                                            if (reader == null) break block67;
                                            try {
                                                reader.dispose();
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if (closeMe && inputStream != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (Throwable t32222222222) {
                                                // empty catch block
                                            }
                                        }
                                        return url22222222222222222222;
                                    }
                                    reader = spi.createReaderInstance();
                                    inputStream.mark();
                                    reader.setInput(inputStream);
                                    metadata = reader.getImageMetadata(0);
                                    if (metadata != null) break block68;
                                    t32222222222 = false;
                                    if (reader == null) break block69;
                                    try {
                                        reader.dispose();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (closeMe && inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable t22222222222222222222) {
                                        // empty catch block
                                    }
                                }
                                return t32222222222;
                            }
                            metadataAdapter = new GeoTiffIIOMetadataDecoder(metadata);
                            if (metadataAdapter != null) break block70;
                            t22222222222222222222 = false;
                            if (reader == null) break block71;
                            try {
                                reader.dispose();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (closeMe && inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable t5) {
                                // empty catch block
                            }
                        }
                        return t22222222222222222222;
                    }
                    if (metadataAdapter.getGeoKeyRevision() == 1) break block72;
                    t22222222222222222222 = false;
                    if (reader == null) break block73;
                    try {
                        reader.dispose();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable t6) {
                        // empty catch block
                    }
                }
                return t22222222222222222222;
            }
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (closeMe && inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable t) {}
            }
            break block74;
            catch (Throwable e) {
                try {
                    MathTransform raster2Model;
                    if (e instanceof IllegalArgumentException && (raster2Model = GeoTiffReader.parseWorldFile(o)) != null) {
                        boolean t22222222222222222222 = true;
                        return t22222222222222222222;
                    }
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            {
                finally {
                    if (reader != null) {
                        try {
                            reader.dispose();
                        }
                        catch (Exception e2) {}
                    }
                    if (closeMe && inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
        }
        return true;
    }

    public GeoTiffReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GeoTiffReader getReader(Object source, Hints hints) {
        if (source instanceof URL) {
            URL url = (URL)source;
            try {
                File file = DataUtilities.urlToFile(url);
                return new GeoTiffReader(file, hints);
            }
            catch (DataSourceException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        try {
            return new GeoTiffReader(source, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GeoTiffWriter(destination, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GeoTiffWriter(destination);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return new GeoTiffWriteParams();
    }
}

