/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.LenientBuilder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public interface Action {
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 4;

    public int getType();

    public Filter getFilter();

    public String getTypeName();

    public static class InsertAction
    implements Action {
        private final SimpleFeature feature;

        public InsertAction(SimpleFeature f) {
            SimpleFeature feature;
            try {
                feature = LenientBuilder.copy(f);
            }
            catch (IllegalAttributeException e) {
                Logging.getLogger((String)"org.geotools.data.wfs").warning("Failed to duplicate feature:" + f);
                feature = f;
            }
            this.feature = feature;
        }

        public int getType() {
            return 1;
        }

        public SimpleFeature getFeature() {
            return this.feature;
        }

        public String getTypeName() {
            return this.feature == null ? null : this.feature.getType().getName().getLocalPart();
        }

        public Filter getFilter() {
            if (this.feature == null) {
                return Filter.EXCLUDE;
            }
            String fid = this.feature.getID();
            if (fid != null) {
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
                FeatureId identifier = ff.featureId(fid);
                HashSet<FeatureId> fids = new HashSet<FeatureId>();
                fids.add(identifier);
                Id filter = ff.id(fids);
                return filter;
            }
            return Filter.EXCLUDE;
        }

        public String toString() {
            return "INSERT " + this.feature;
        }
    }

    public static class DeleteAction
    implements Action {
        private final Filter filter;
        private final String typeName;

        public DeleteAction(String typeName, Filter f) {
            DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor();
            this.filter = (Filter)f.accept((FilterVisitor)visitor, null);
            this.typeName = typeName;
        }

        public int getType() {
            return 4;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String toString() {
            return "REMOVE " + this.filter;
        }
    }

    public static class UpdateAction
    implements Action {
        private final Filter filter;
        private final Map properties;
        private final String typeName;

        public UpdateAction(String typeName, Filter f, Map properties) {
            DuplicatingFilterVisitor duplicator = new DuplicatingFilterVisitor();
            DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor();
            this.filter = (Filter)f.accept((FilterVisitor)visitor, null);
            this.properties = new HashMap(properties);
            this.typeName = typeName;
        }

        public int getType() {
            return 2;
        }

        public Object getProperty(String name) {
            return this.properties == null ? null : this.properties.get(name);
        }

        public String[] getPropertyNames() {
            return this.properties == null ? new String[]{} : this.properties.keySet().toArray(new String[this.properties.keySet().size()]);
        }

        public Map getProperties() {
            return this.properties == null ? null : new HashMap(this.properties);
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void update(SimpleFeature feature) {
            if (!this.filter.evaluate((Object)feature)) {
                throw new IllegalArgumentException(feature + "is not affected by this update, only call update on features that" + "the Action applies to!");
            }
            String[] propNames = this.getPropertyNames();
            for (int j = 0; j < propNames.length; ++j) {
                try {
                    feature.setAttribute(propNames[j], this.getProperty(propNames[j]));
                    continue;
                }
                catch (IllegalAttributeException e) {
                    NoSuchElementException ee = new NoSuchElementException(e.getMessage());
                    ee.initCause((Throwable)((Object)e));
                    throw ee;
                }
            }
        }

        public String toString() {
            return "UPDATE " + this.filter + " " + this.properties;
        }
    }
}

