/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;

public abstract class FeatureTypeSchema {
    protected FeatureTypeInfo featureType;
    protected FeatureTypeSchemaBuilder builder;
    protected Catalog catalog;
    protected WFSInfo wfs;

    protected FeatureTypeSchema(FeatureTypeInfo featureType, WFSInfo wfs, Catalog catalog) {
        this.featureType = featureType;
        this.catalog = catalog;
        this.wfs = wfs;
    }

    FeatureTypeInfo getFeatureType() {
        return this.featureType;
    }

    public XSDSchema schema(String baseUrl) throws IOException {
        return this.builder.build(new FeatureTypeInfo[]{this.featureType}, baseUrl);
    }

    public FeatureTypeSchema toGML2() {
        if (this instanceof GML2) {
            return this;
        }
        return new GML2(this.featureType, this.wfs, this.catalog);
    }

    public FeatureTypeSchema toGML3() {
        if (this instanceof GML3) {
            return this;
        }
        return new GML3(this.featureType, this.wfs, this.catalog);
    }

    public static final class GML3
    extends FeatureTypeSchema {
        protected GML3(FeatureTypeInfo featureType, WFSInfo wfs, Catalog catalog) {
            super(featureType, wfs, catalog);
            this.builder = new FeatureTypeSchemaBuilder.GML3(wfs.getGeoServer());
        }
    }

    public static final class GML2
    extends FeatureTypeSchema {
        public GML2(FeatureTypeInfo featureType, WFSInfo wfs, Catalog catalog) {
            super(featureType, wfs, catalog);
            this.builder = new FeatureTypeSchemaBuilder.GML2(wfs.getGeoServer());
        }
    }
}

