/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequestResponse;
import org.geoserver.web.wicket.EditAreaBehavior;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoRequestsPage
extends GeoServerBasePage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.demo");
    private final File demoDir;
    private TextField urlTextField;
    private TextArea body;
    private TextField username;
    private PasswordTextField password;

    public DemoRequestsPage() {
        try {
            this.demoDir = GeoserverDataDirectory.findCreateConfigDir((String)"demo/");
        }
        catch (ConfigurationException e) {
            throw new WicketRuntimeException("Can't access demo requests directory: " + e.getMessage());
        }
        DemoRequest model = new DemoRequest(this.demoDir);
        this.setModel((IModel)new Model((Serializable)model));
        this.setUpDemoRequestsForm(this.demoDir);
    }

    DemoRequestsPage(File demoDir) {
        this.demoDir = demoDir;
        DemoRequest model = new DemoRequest(demoDir);
        this.setModel((IModel)new Model((Serializable)model));
        this.setUpDemoRequestsForm(demoDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(String reqFileName) throws IOException {
        File file = new File(this.demoDir, reqFileName);
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    private void setUpDemoRequestsForm(File demoDir) {
        final IModel requestModel = this.getModel();
        Form demoRequestsForm = new Form("demoRequestsForm");
        demoRequestsForm.setOutputMarkupId(true);
        demoRequestsForm.setModel(requestModel);
        this.add((Component)demoRequestsForm);
        List<String> demoList = this.getDemoList(demoDir);
        PropertyModel reqFileNameModel = new PropertyModel((Object)requestModel, "requestFileName");
        final DropDownChoice demoRequestsList = new DropDownChoice("demoRequestsList", (IModel)reqFileNameModel, demoList, new IChoiceRenderer(){

            public String getIdValue(Object obj, int index) {
                return String.valueOf(obj);
            }

            public Object getDisplayValue(Object obj) {
                return obj;
            }
        });
        demoRequestsForm.add((Component)demoRequestsList);
        demoRequestsList.add((IBehavior)new AjaxFormSubmitBehavior(demoRequestsForm, "onchange"){

            protected void onSubmit(AjaxRequestTarget target) {
                String contents;
                String reqFileName = demoRequestsList.getModelValue();
                WebRequest request = (WebRequest)DemoRequestsPage.this.getRequest();
                HttpServletRequest httpServletRequest = request.getHttpServletRequest();
                String baseUrl = ResponseUtils.baseURL((HttpServletRequest)httpServletRequest);
                try {
                    contents = DemoRequestsPage.this.getFileContents(reqFileName);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Can't load demo file " + reqFileName, e);
                    throw new WicketRuntimeException("Can't load demo file " + reqFileName, (Throwable)e);
                }
                boolean demoRequestIsHttpGet = reqFileName.endsWith(".url");
                String service = reqFileName.substring(0, reqFileName.indexOf(95)).toLowerCase();
                String serviceUrl = baseUrl + service;
                if (demoRequestIsHttpGet) {
                    String url = baseUrl + contents;
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)url);
                    DemoRequestsPage.this.body.setModelObject((Object)"");
                } else {
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)serviceUrl);
                    DemoRequestsPage.this.body.setModelObject((Object)contents);
                }
                DemoRequestsPage.this.setResponsePage((Page)DemoRequestsPage.this);
            }

            protected void onError(AjaxRequestTarget target) {
            }
        });
        this.urlTextField = new TextField("url", (IModel)new PropertyModel((Object)requestModel, "requestUrl"));
        this.urlTextField.setMarkupId("requestUrl");
        this.urlTextField.setOutputMarkupId(true);
        demoRequestsForm.add((Component)this.urlTextField);
        this.body = new TextArea("body", (IModel)new PropertyModel((Object)requestModel, "requestBody"));
        this.body.setMarkupId("requestBody");
        this.body.setOutputMarkupId(true);
        this.body.add((IBehavior)new EditAreaBehavior());
        demoRequestsForm.add((Component)this.body);
        this.username = new TextField("username", (IModel)new PropertyModel((Object)requestModel, "userName"));
        demoRequestsForm.add((Component)this.username);
        this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)requestModel, "password"));
        this.password.setRequired(false);
        demoRequestsForm.add((Component)this.password);
        final ModalWindow responseWindow = new ModalWindow("responseWindow");
        this.add((Component)responseWindow);
        responseWindow.setPageMapName("demoResponse");
        responseWindow.setCookieName("demoResponse");
        responseWindow.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new DemoRequestResponse(requestModel);
            }
        });
        demoRequestsForm.add((Component)new AjaxSubmitLink("submit", demoRequestsForm){

            public void onSubmit(AjaxRequestTarget target, Form testWfsPostForm) {
                responseWindow.show(target);
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxCallDecorator(){

                    public CharSequence decorateScript(CharSequence script) {
                        return "document.getElementById('requestBody').value = editAreaLoader.getValue('requestBody');" + script;
                    }
                };
            }
        });
    }

    private List<String> getDemoList(File demoDir) {
        ArrayList<String> demoList = new ArrayList<String>();
        for (File file : demoDir.listFiles()) {
            if (file.isDirectory()) continue;
            String name = file.getName();
            if (name.endsWith(".url") || name.endsWith(".xml")) {
                demoList.add(name);
                continue;
            }
            LOGGER.warning("Ignoring file " + name + " in demo requests directory, only .url and .xml files allowed");
        }
        Collections.sort(demoList);
        return demoList;
    }

    static class DemoRequest
    implements Serializable {
        private final File demoDir;
        private String requestFileName;
        private String requestUrl;
        private String requestBody;
        private String userName;
        private String password;

        DemoRequest(File demoDir) {
            this.demoDir = demoDir;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getRequestFileName() {
            return this.requestFileName;
        }

        public void setRequestFileName(String requestFileName) {
            this.requestFileName = requestFileName;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }

        public void setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
        }

        public String getRequestBody() {
            return this.requestBody;
        }

        public void setRequestBody(String requestBody) {
            this.requestBody = requestBody;
        }

        public File getDemoDir() {
            return this.demoDir;
        }
    }
}

