/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogBuilder {
    static final Logger LOGGER = Logging.getLogger(CatalogBuilder.class);
    Catalog catalog;
    WorkspaceInfo workspace;
    StoreInfo store;

    public CatalogBuilder(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    public void setStore(StoreInfo store) {
        this.store = store;
    }

    public void updateWorkspace(WorkspaceInfo original, WorkspaceInfo update) {
        this.update(original, update, WorkspaceInfo.class);
    }

    public void updateNamespace(NamespaceInfo original, NamespaceInfo update) {
        this.update(original, update, NamespaceInfo.class);
    }

    public void updateDataStore(DataStoreInfo original, DataStoreInfo update) {
        this.update(original, update, DataStoreInfo.class);
    }

    public void updateCoverageStore(CoverageStoreInfo original, CoverageStoreInfo update) {
        this.update(original, update, CoverageStoreInfo.class);
    }

    public void updateFeatureType(FeatureTypeInfo original, FeatureTypeInfo update) {
        this.update(original, update, FeatureTypeInfo.class);
    }

    public void updateCoverage(CoverageInfo original, CoverageInfo update) {
        this.update(original, update, CoverageInfo.class);
    }

    public void updateLayer(LayerInfo original, LayerInfo update) {
        this.update(original, update, LayerInfo.class);
    }

    public void updateLayerGroup(LayerGroupInfo original, LayerGroupInfo update) {
        this.update(original, update, LayerGroupInfo.class);
    }

    public void updateStyle(StyleInfo original, StyleInfo update) {
        this.update(original, update, StyleInfo.class);
    }

    <T> void update(T original, T update, Class<T> clazz) {
        ClassProperties properties = OwsUtils.getClassProperties(clazz);
        for (String p : properties.properties()) {
            Class<?> type;
            Method setter;
            Method getter = properties.getter(p, null);
            if (getter == null || (setter = properties.setter(p, type = getter.getReturnType())) == null && !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type)) continue;
            try {
                Object newValue = getter.invoke(update, null);
                if (newValue == null) continue;
                if (setter == null) {
                    if (Collection.class.isAssignableFrom(type)) {
                        this.updateCollectionProperty(original, (Collection)newValue, getter);
                        continue;
                    }
                    if (!Map.class.isAssignableFrom(type)) continue;
                    this.updateMapProperty(original, (Map)newValue, getter);
                    continue;
                }
                setter.invoke(original, newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void updateCollectionProperty(Object object, Collection newValue, Method getter) throws Exception {
        Collection oldValue = (Collection)getter.invoke(object, null);
        oldValue.clear();
        oldValue.addAll(newValue);
    }

    void updateMapProperty(Object object, Map newValue, Method getter) throws Exception {
        Map oldValue = (Map)getter.invoke(object, null);
        oldValue.clear();
        oldValue.putAll(newValue);
    }

    public DataStoreInfo buildDataStore(String name) {
        DataStoreInfo info = this.catalog.getFactory().createDataStore();
        this.buildStore(info, name);
        return info;
    }

    public CoverageStoreInfo buildCoverageStore(String name) {
        CoverageStoreInfo info = this.catalog.getFactory().createCoverageStore();
        this.buildStore(info, name);
        return info;
    }

    void buildStore(StoreInfo info, String name) {
        info.setName(name);
        info.setEnabled(true);
        if (this.workspace != null) {
            info.setWorkspace(this.workspace);
        } else {
            info.setWorkspace(this.catalog.getDefaultWorkspace());
        }
    }

    public FeatureTypeInfo buildFeatureType(Name typeName) throws Exception {
        if (this.store == null || !(this.store instanceof DataStoreInfo)) {
            throw new IllegalStateException("Data store not set.");
        }
        DataStoreInfo dstore = (DataStoreInfo)this.store;
        return this.buildFeatureType(dstore.getDataStore(null).getFeatureSource(typeName));
    }

    public FeatureTypeInfo buildFeatureType(FeatureSource featureSource) {
        if (this.store == null || !(this.store instanceof DataStoreInfo)) {
            throw new IllegalStateException("Data store not set.");
        }
        FeatureType featureType = featureSource.getSchema();
        FeatureTypeInfo ftinfo = this.catalog.getFactory().createFeatureType();
        ftinfo.setStore(this.store);
        ftinfo.setEnabled(true);
        ftinfo.setNativeName(featureType.getName().getLocalPart());
        ftinfo.setName(featureType.getName().getLocalPart());
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        ftinfo.setNamespace(namespace);
        CoordinateReferenceSystem crs = featureType.getCoordinateReferenceSystem();
        if (crs == null && featureType.getGeometryDescriptor() != null) {
            crs = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
        }
        ftinfo.setNativeCRS(crs);
        try {
            this.lookupSRS(ftinfo, false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SRS lookup failed", e);
        }
        this.setupProjectionPolicy(ftinfo);
        ftinfo.setTitle(featureType.getName().getLocalPart());
        return ftinfo;
    }

    public void setupProjectionPolicy(ResourceInfo rinfo) {
        if (rinfo.getSRS() != null) {
            rinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        } else {
            rinfo.setProjectionPolicy(ProjectionPolicy.NONE);
        }
    }

    public void setupBounds(ResourceInfo rinfo) throws IOException {
        if (rinfo.getNativeBoundingBox() == null) {
            ReferencedEnvelope bounds = this.getNativeBounds(rinfo);
            rinfo.setNativeBoundingBox(bounds);
        }
        rinfo.setLatLonBoundingBox(this.getLatLonBounds(rinfo.getNativeBoundingBox(), rinfo.getCRS()));
    }

    public ReferencedEnvelope getLatLonBounds(ReferencedEnvelope nativeBounds, CoordinateReferenceSystem declaredCRS) throws IOException {
        if (nativeBounds != null && declaredCRS != null) {
            if (!CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)declaredCRS)) {
                try {
                    ReferencedEnvelope bounds = new ReferencedEnvelope((Envelope)nativeBounds, declaredCRS);
                    return bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw (IOException)new IOException("transform error").initCause(e);
                }
            }
            return new ReferencedEnvelope((Envelope)nativeBounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        return null;
    }

    public ReferencedEnvelope getNativeBounds(ResourceInfo rinfo) throws IOException {
        ReferencedEnvelope bounds = null;
        if (rinfo instanceof FeatureTypeInfo) {
            FeatureTypeInfo ftinfo = (FeatureTypeInfo)rinfo;
            bounds = ftinfo.getFeatureSource(null, null).getBounds();
            CoordinateReferenceSystem crs = ftinfo.getNativeCRS();
            if (bounds != null && bounds.getCoordinateReferenceSystem() == null && crs != null) {
                bounds = new ReferencedEnvelope((Envelope)bounds, crs);
            }
            if (bounds != null) {
                double expandBy = 1.0;
                if (bounds.getCoordinateReferenceSystem() instanceof GeographicCRS) {
                    expandBy = 1.0E-4;
                }
                if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
                    bounds.expandBy(expandBy);
                }
            }
        } else if (rinfo instanceof CoverageInfo) {
            CoverageInfo cinfo = (CoverageInfo)rinfo;
            AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)cinfo.getGridCoverageReader(null, null);
            bounds = new ReferencedEnvelope((org.opengis.geometry.Envelope)reader.getOriginalEnvelope());
        }
        if (rinfo.getProjectionPolicy() == ProjectionPolicy.REPROJECT_TO_DECLARED && bounds != null) {
            try {
                bounds = bounds.transform(rinfo.getCRS(), true);
                GridGeometry grid = ((CoverageInfo)rinfo).getGrid();
                ((CoverageInfo)rinfo).setGrid((GridGeometry)new GridGeometry2D(grid.getGridRange(), grid.getGridToCRS(), rinfo.getCRS()));
            }
            catch (Exception e) {
                throw (IOException)new IOException("transform error").initCause(e);
            }
        }
        return bounds;
    }

    public void lookupSRS(FeatureTypeInfo ftinfo, boolean extensive) throws IOException {
        CoordinateReferenceSystem crs = ftinfo.getNativeCRS();
        if (crs == null) {
            crs = ftinfo.getFeatureType().getCoordinateReferenceSystem();
        }
        if (crs != null) {
            try {
                Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)extensive);
                if (code != null) {
                    ftinfo.setSRS("EPSG:" + code);
                }
            }
            catch (FactoryException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    public void initFeatureType(FeatureTypeInfo featureType) throws Exception {
        if (featureType.getCatalog() == null) {
            featureType.setCatalog(this.catalog);
        }
        if (featureType.getNativeName() == null && featureType.getName() != null) {
            featureType.setNativeName(featureType.getName());
        }
        if (featureType.getNativeName() != null && featureType.getName() == null) {
            featureType.setName(featureType.getNativeName());
        }
        if (featureType.getSRS() == null) {
            this.lookupSRS(featureType, true);
        }
        if (featureType.getProjectionPolicy() == null) {
            this.setupProjectionPolicy(featureType);
        }
        CoordinateReferenceSystem crs = featureType.getCRS();
        if (featureType.getLatLonBoundingBox() == null && featureType.getNativeBoundingBox() == null) {
            this.setupBounds(featureType);
        } else if (featureType.getLatLonBoundingBox() == null) {
            this.setupBounds(featureType);
        } else if (featureType.getNativeBoundingBox() == null && crs != null) {
            ReferencedEnvelope boundsLatLon = featureType.getLatLonBoundingBox();
            featureType.setNativeBoundingBox(boundsLatLon.transform(crs, true));
        }
    }

    public CoverageInfo buildCoverage() throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(csinfo, null);
        if (reader == null) {
            throw new Exception("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        return this.buildCoverage(reader);
    }

    public CoverageInfo buildCoverage(AbstractGridCoverage2DReader reader) throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        CoverageInfo cinfo = this.catalog.getFactory().createCoverage();
        cinfo.setStore(csinfo);
        cinfo.setEnabled(true);
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        cinfo.setNamespace(namespace);
        CoordinateReferenceSystem nativeCRS = reader.getCrs();
        cinfo.setNativeCRS(nativeCRS);
        if (nativeCRS != null && !nativeCRS.getIdentifiers().isEmpty()) {
            cinfo.setSRS(nativeCRS.getIdentifiers().toArray()[0].toString());
            cinfo.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
        }
        if (nativeCRS == null) {
            cinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        }
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        cinfo.setNativeBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope));
        cinfo.setLatLonBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)CoverageStoreUtils.getWGS84LonLatEnvelope(envelope)));
        GridEnvelope originalRange = reader.getOriginalGridRange();
        cinfo.setGrid((GridGeometry)new GridGeometry2D(originalRange, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), nativeCRS));
        AbstractGridFormat format = csinfo.getFormat();
        ParameterValueGroup readParams = format.getReadParameters();
        Map parameters = CoverageUtils.getParametersKVP(readParams);
        int minX = originalRange.getLow(0);
        int minY = originalRange.getLow(1);
        int width = originalRange.getSpan(0);
        int height = originalRange.getSpan(1);
        int maxX = minX + (width <= 5 ? width : 5);
        int maxY = minY + (height <= 5 ? height : 5);
        GridEnvelope2D testRange = new GridEnvelope2D(minX, minY, maxX, maxY);
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralEnvelope testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (org.opengis.geometry.Envelope)new GeneralEnvelope((Rectangle2D)testRange.getBounds()));
        testEnvelope.setCoordinateReferenceSystem(nativeCRS);
        parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridEnvelope)testRange, (org.opengis.geometry.Envelope)testEnvelope));
        GridCoverage2D gc = reader.read(CoverageUtils.getParameters(readParams, parameters, true));
        if (gc == null) {
            throw new Exception("Unable to acquire test coverage for format:" + format.getName());
        }
        cinfo.getDimensions().addAll(this.getCoverageDimensions(gc.getSampleDimensions()));
        String name = gc.getName().toString();
        cinfo.setName(name);
        cinfo.setTitle(name);
        cinfo.setDescription(new StringBuffer("Generated from ").append(format.getName()).toString());
        cinfo.getKeywords().add("WCS");
        cinfo.getKeywords().add(format.getName());
        cinfo.getKeywords().add(name);
        cinfo.setNativeFormat(format.getName());
        cinfo.getMetadata().put("dirName", (Serializable)((Object)new StringBuffer(this.store.getName()).append("_").append(name).toString()));
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            cinfo.getRequestSRS().add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            cinfo.getResponseSRS().add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        List formats = CoverageStoreUtils.listDataFormats();
        for (Format fTmp : formats) {
            String fName = fTmp.getName();
            if (fName.equalsIgnoreCase("WorldImage")) {
                cinfo.getSupportedFormats().add("GIF");
                cinfo.getSupportedFormats().add("PNG");
                cinfo.getSupportedFormats().add("JPEG");
                cinfo.getSupportedFormats().add("TIFF");
                continue;
            }
            if (fName.toLowerCase().startsWith("geotiff")) {
                cinfo.getSupportedFormats().add("GEOTIFF");
                continue;
            }
            cinfo.getSupportedFormats().add(fName);
        }
        cinfo.setDefaultInterpolationMethod("nearest neighbor");
        cinfo.getInterpolationMethods().add("nearest neighbor");
        cinfo.getInterpolationMethods().add("bilinear");
        cinfo.getInterpolationMethods().add("bicubic");
        cinfo.getParameters().putAll(CoverageUtils.getParametersKVP(format.getReadParameters()));
        return cinfo;
    }

    List<CoverageDimensionInfo> getCoverageDimensions(GridSampleDimension[] sampleDimensions) {
        int length = sampleDimensions.length;
        ArrayList<CoverageDimensionInfo> dims = new ArrayList<CoverageDimensionInfo>();
        for (int i = 0; i < length; ++i) {
            CoverageDimensionInfo dim = this.catalog.getFactory().createCoverageDimension();
            dim.setName(sampleDimensions[i].getDescription().toString(Locale.getDefault()));
            StringBuffer label = new StringBuffer("GridSampleDimension".intern());
            Unit uom = sampleDimensions[i].getUnits();
            if (uom != null) {
                label.append("(".intern());
                this.parseUOM(label, uom);
                label.append(")".intern());
            }
            label.append("[".intern());
            label.append(sampleDimensions[i].getMinimumValue());
            label.append(",".intern());
            label.append(sampleDimensions[i].getMaximumValue());
            label.append("]".intern());
            dim.setDescription(label.toString());
            dim.setRange(sampleDimensions[i].getRange());
            List categories = sampleDimensions[i].getCategories();
            if (categories != null) {
                for (Category cat : categories) {
                    if (cat == null || !cat.getName().toString().equalsIgnoreCase("no data")) continue;
                    double min = cat.getRange().getMinimum();
                    double max = cat.getRange().getMaximum();
                    dim.getNullValues().add(min);
                    if (min == max) continue;
                    dim.getNullValues().add(max);
                }
            }
            dims.add(dim);
        }
        return dims;
    }

    void parseUOM(StringBuffer label, Unit uom) {
        String uomString = uom.toString();
        uomString = uomString.replaceAll("\ufffd", "^2");
        uomString = uomString.replaceAll("\ufffd", "^3");
        uomString = uomString.replaceAll("\ufffd", "A");
        uomString = uomString.replaceAll("\ufffd", "");
        label.append(uomString);
    }

    public LayerInfo buildLayer(FeatureTypeInfo featureType) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)featureType);
        StyleInfo style = this.getDefaultStyle(featureType);
        layer.setDefaultStyle(style);
        return layer;
    }

    public LayerInfo buildLayer(CoverageInfo coverage) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)coverage);
        layer.setDefaultStyle(this.getDefaultStyle(coverage));
        return layer;
    }

    public StyleInfo getDefaultStyle(ResourceInfo resource) throws IOException {
        if (resource instanceof CoverageInfo) {
            return this.catalog.getStyleByName("raster");
        }
        FeatureTypeInfo featureType = (FeatureTypeInfo)resource;
        GeometryDescriptor gd = featureType.getFeatureType().getGeometryDescriptor();
        if (gd == null) {
            return null;
        }
        Class gtype = gd.getType().getBinding();
        String styleName = Point.class.isAssignableFrom(gtype) || MultiPoint.class.isAssignableFrom(gtype) ? "point" : (LineString.class.isAssignableFrom(gtype) || MultiLineString.class.isAssignableFrom(gtype) ? "line" : (Polygon.class.isAssignableFrom(gtype) || MultiPolygon.class.isAssignableFrom(gtype) ? "polygon" : "point"));
        return this.catalog.getStyleByName(styleName);
    }

    LayerInfo buildLayer(ResourceInfo resource) {
        LayerInfo layer = this.catalog.getFactory().createLayer();
        layer.setResource(resource);
        layer.setName(resource.getName());
        layer.setEnabled(true);
        if (layer.getResource() instanceof FeatureTypeInfo) {
            layer.setType(LayerInfo.Type.VECTOR);
        } else if (layer.getResource() instanceof CoverageInfo) {
            layer.setType(LayerInfo.Type.RASTER);
        }
        return layer;
    }

    public void calculateLayerGroupBounds(LayerGroupInfo lg, CoordinateReferenceSystem crs) throws Exception {
        if (lg.getLayers().isEmpty()) {
            return;
        }
        LayerInfo l = lg.getLayers().get(0);
        ReferencedEnvelope bounds = this.transform(l.getResource().getLatLonBoundingBox(), crs);
        for (int i = 1; i < lg.getLayers().size(); ++i) {
            l = lg.getLayers().get(i);
            bounds.expandToInclude((Envelope)this.transform(l.getResource().getLatLonBoundingBox(), crs));
        }
        lg.setBounds(bounds);
    }

    public void calculateLayerGroupBounds(LayerGroupInfo lg) throws Exception {
        if (lg.getLayers().isEmpty()) {
            return;
        }
        LayerInfo l = lg.getLayers().get(0);
        ReferencedEnvelope bounds = l.getResource().boundingBox();
        boolean latlon = false;
        if (bounds == null) {
            bounds = l.getResource().getLatLonBoundingBox();
            latlon = true;
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
        }
        for (int i = 1; i < lg.getLayers().size(); ++i) {
            l = lg.getLayers().get(i);
            ReferencedEnvelope re = latlon ? l.getResource().getLatLonBoundingBox() : l.getResource().boundingBox();
            if ((re = this.transform(re, bounds.getCoordinateReferenceSystem())) == null) {
                throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
            }
            bounds.expandToInclude((Envelope)re);
        }
        lg.setBounds(bounds);
    }

    ReferencedEnvelope transform(ReferencedEnvelope e, CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)e.getCoordinateReferenceSystem())) {
            return e.transform(crs, true);
        }
        return e;
    }

    public void removeWorkspace(WorkspaceInfo workspace, boolean recursive) {
        if (recursive) {
            workspace.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(workspace);
        }
    }

    public void removeStore(StoreInfo store, boolean recursive) {
        if (recursive) {
            store.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(store);
        }
    }

    public void removeResource(ResourceInfo resource, boolean recursive) {
        if (recursive) {
            resource.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(resource);
        }
    }

    public void attach(StoreInfo storeInfo) {
        storeInfo = ModificationProxy.unwrap(storeInfo);
        ((StoreInfoImpl)storeInfo).setCatalog(this.catalog);
    }

    public void attach(ResourceInfo resourceInfo) {
        resourceInfo = ModificationProxy.unwrap(resourceInfo);
        ((ResourceInfoImpl)resourceInfo).setCatalog(this.catalog);
    }

    public void attach(LayerInfo layerInfo) {
        this.attach(layerInfo.getResource());
    }

    public void attach(MapInfo mapInfo) {
        for (LayerInfo layer : mapInfo.getLayers()) {
            this.attach(layer);
        }
    }

    public void attach(LayerGroupInfo groupInfo) {
        for (LayerInfo layer : groupInfo.getLayers()) {
            this.attach(layer);
        }
        for (StyleInfo style : groupInfo.getStyles()) {
            if (style == null) continue;
            this.attach(style);
        }
    }

    public void attach(StyleInfo styleInfo) {
        styleInfo = ModificationProxy.unwrap(styleInfo);
        ((StyleInfoImpl)styleInfo).setCatalog(this.catalog);
    }

    public void attach(NamespaceInfo nsInfo) {
    }

    public void attach(WorkspaceInfo wsInfo) {
    }
}

