/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessRule;
import org.geoserver.security.DataAccessRuleDAO;
import org.geoserver.security.SecureTreeNode;
import org.geotools.util.logging.Logging;

public class DefaultDataAccessManager
implements DataAccessManager {
    static final Logger LOGGER = Logging.getLogger(DataAccessManager.class);
    SecureTreeNode root;
    DataAccessRuleDAO dao;
    long lastLoaded = Long.MIN_VALUE;

    DefaultDataAccessManager(DataAccessRuleDAO dao) {
        this.dao = dao;
        this.root = this.buildAuthorizationTree(dao);
    }

    public DataAccessManager.CatalogMode getMode() {
        return this.dao.getMode();
    }

    public boolean canAccess(Authentication user, WorkspaceInfo workspace, AccessMode mode) {
        this.checkPropertyFile();
        SecureTreeNode node = this.root.getDeepestNode(new String[]{workspace.getName()});
        return node.canAccess(user, mode);
    }

    public boolean canAccess(Authentication user, LayerInfo layer, AccessMode mode) {
        this.checkPropertyFile();
        if (layer.getResource() == null) {
            LOGGER.log(Level.FINE, "Layer " + layer + " has no attached resource, " + "assuming it's possible to access it");
            return true;
        }
        return this.canAccess(user, layer.getResource(), mode);
    }

    public boolean canAccess(Authentication user, ResourceInfo resource, AccessMode mode) {
        String workspace;
        this.checkPropertyFile();
        try {
            workspace = resource.getStore().getWorkspace().getName();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Errors occurred trying to gather workspace of resource " + resource.getName());
            return true;
        }
        SecureTreeNode node = this.root.getDeepestNode(new String[]{workspace, resource.getName()});
        return node.canAccess(user, mode);
    }

    void checkPropertyFile() {
        long daoLastModified = this.dao.getLastModified();
        if (this.lastLoaded < daoLastModified) {
            this.root = this.buildAuthorizationTree(this.dao);
            this.lastLoaded = daoLastModified;
        }
    }

    SecureTreeNode buildAuthorizationTree(DataAccessRuleDAO dao) {
        SecureTreeNode root = new SecureTreeNode();
        for (DataAccessRule rule : dao.getRules()) {
            SecureTreeNode node;
            String workspace = rule.getWorkspace();
            String layer = rule.getLayer();
            AccessMode accessMode = rule.getAccessMode();
            if ("*".equals(workspace)) {
                node = root;
            } else {
                SecureTreeNode ws = root.getChild(workspace);
                if (ws == null) {
                    ws = root.addChild(workspace);
                }
                if ("*".equals(layer)) {
                    node = ws;
                } else {
                    SecureTreeNode layerNode = ws.getChild(layer);
                    if (layerNode == null) {
                        layerNode = ws.addChild(layer);
                    }
                    node = layerNode;
                }
            }
            if (node.getAuthorizedRoles(accessMode) != null && node.getAuthorizedRoles(accessMode).size() > 0 && node != root) {
                LOGGER.warning("Rule " + rule + " is overriding another rule targetting the same resource");
            }
            node.setAuthorizedRoles(accessMode, rule.getRoles());
        }
        return root;
    }
}

