/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.AbstractDecorator;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.AccessMode;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessRuleDAO;
import org.geoserver.security.DefaultDataAccessManager;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredCoverageStoreInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerGroupInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureCatalogImpl
extends AbstractDecorator<Catalog>
implements Catalog {
    protected DataAccessManager accessManager;

    public SecureCatalogImpl(Catalog catalog) throws Exception {
        this(catalog, SecureCatalogImpl.lookupDataAccessManager(catalog));
    }

    @Override
    public String getId() {
        return ((Catalog)this.delegate).getId();
    }

    static DataAccessManager lookupDataAccessManager(Catalog catalog) throws Exception {
        DataAccessManager manager = (DataAccessManager)GeoServerExtensions.bean(DataAccessManager.class);
        if (manager == null) {
            manager = new DefaultDataAccessManager((DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class));
        }
        return manager;
    }

    SecureCatalogImpl(Catalog catalog, DataAccessManager manager) {
        super(catalog);
        this.accessManager = manager;
    }

    @Override
    public CoverageInfo getCoverage(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverage(id));
    }

    @Override
    public CoverageInfo getCoverageByName(String ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(ns, name));
    }

    @Override
    public CoverageInfo getCoverageByName(NamespaceInfo ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(ns, name));
    }

    @Override
    public CoverageInfo getCoverageByName(Name name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(name));
    }

    @Override
    public CoverageInfo getCoverageByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(name));
    }

    @Override
    public List<CoverageInfo> getCoverages() {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverages());
    }

    @Override
    public List<CoverageInfo> getCoveragesByNamespace(NamespaceInfo namespace) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoveragesByNamespace(namespace));
    }

    @Override
    public List<CoverageInfo> getCoveragesByCoverageStore(CoverageStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoveragesByCoverageStore(store));
    }

    @Override
    public CoverageInfo getCoverageByCoverageStore(CoverageStoreInfo coverageStore, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByCoverageStore(coverageStore, name));
    }

    @Override
    public List<CoverageInfo> getCoveragesByStore(CoverageStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoveragesByStore(store));
    }

    @Override
    public CoverageStoreInfo getCoverageStore(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStore(id));
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoreByName(name));
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String workspaceName, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoreByName(workspaceName, name));
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoreByName(workspace, name));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(String workspaceName) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoresByWorkspace(workspaceName));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(WorkspaceInfo workspace) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoresByWorkspace(workspace));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStores() {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStores());
    }

    @Override
    public DataStoreInfo getDataStore(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStore(id));
    }

    @Override
    public DataStoreInfo getDataStoreByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoreByName(name));
    }

    @Override
    public DataStoreInfo getDataStoreByName(String workspaceName, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoreByName(workspaceName, name));
    }

    @Override
    public DataStoreInfo getDataStoreByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoreByName(workspace, name));
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(String workspaceName) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoresByWorkspace(workspaceName));
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(WorkspaceInfo workspace) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoresByWorkspace(workspace));
    }

    @Override
    public List<DataStoreInfo> getDataStores() {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStores());
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return ((Catalog)this.delegate).getDefaultNamespace();
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return ((Catalog)this.delegate).getDefaultWorkspace();
    }

    @Override
    public FeatureTypeInfo getFeatureType(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureType(id));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(ns, name));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(NamespaceInfo ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(ns, name));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(Name name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(name));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(name));
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypes() {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypes());
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByNamespace(NamespaceInfo namespace) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypesByNamespace(namespace));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByStore(DataStoreInfo dataStore, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByStore(dataStore, name));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByDataStore(DataStoreInfo dataStore, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByDataStore(dataStore, name));
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByStore(DataStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypesByStore(store));
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByDataStore(DataStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypesByDataStore(store));
    }

    @Override
    public LayerInfo getLayer(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayer(id));
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerByName(name));
    }

    @Override
    public LayerInfo getLayerByName(Name name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerByName(name));
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroup(id));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroupByName(name));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return this.filterGroups(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroups());
    }

    @Override
    public List<LayerInfo> getLayers() {
        return this.filterLayers(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayers());
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        return this.filterLayers(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayers(SecureCatalogImpl.unwrap(resource)));
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        return this.filterLayers(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayers(style));
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespace(id));
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespaceByPrefix(prefix));
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespaceByURI(uri));
    }

    @Override
    public List<NamespaceInfo> getNamespaces() {
        return this.filterNamespaces(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespaces());
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResource(id, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(Name name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(name, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(name, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo ns, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(ns, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String ns, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(ns, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResources(Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResources(clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo namespace, Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourcesByNamespace(namespace, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(String namespace, Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourcesByNamespace(namespace, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByStore(store, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourcesByStore(store, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStore(id, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoreByName(name, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String workspaceName, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoreByName(workspaceName, name, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoreByName(workspace, name, clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStores(Class<T> clazz) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStores(clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(String workspaceName, Class<T> clazz) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoresByWorkspace(workspaceName, clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoresByWorkspace(workspace, clazz));
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getWorkspace(id));
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getWorkspaceByName(name));
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        return this.filterWorkspaces(SecureCatalogImpl.user(), ((Catalog)this.delegate).getWorkspaces());
    }

    protected static Authentication user() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    protected <T extends ResourceInfo> T checkAccess(Authentication user, T info) {
        boolean canWrite;
        if (info == null) {
            return null;
        }
        boolean canRead = this.accessManager.canAccess(user, info, AccessMode.READ);
        WrapperPolicy policy = this.checkWrapperPolicy(user, canRead, canWrite = this.accessManager.canAccess(user, info, AccessMode.WRITE), info.getName());
        if (policy == WrapperPolicy.HIDE) {
            return null;
        }
        if (policy.level == AccessLevel.READ_WRITE || policy.level == AccessLevel.READ_ONLY && info instanceof CoverageInfo) {
            return info;
        }
        if (info instanceof FeatureTypeInfo) {
            return (T)new SecuredFeatureTypeInfo((FeatureTypeInfo)info, policy);
        }
        if (info instanceof CoverageInfo) {
            return (T)new SecuredCoverageInfo((CoverageInfo)info, policy);
        }
        throw new RuntimeException("Unknown resource type " + info.getClass());
    }

    protected <T extends StoreInfo> T checkAccess(Authentication user, T store) {
        boolean canWrite;
        if (store == null) {
            return null;
        }
        boolean canRead = this.accessManager.canAccess(user, store.getWorkspace(), AccessMode.READ);
        WrapperPolicy policy = this.checkWrapperPolicy(user, canRead, canWrite = this.accessManager.canAccess(user, store.getWorkspace(), AccessMode.WRITE), store.getName());
        if (policy == WrapperPolicy.HIDE) {
            return null;
        }
        if (policy.level == AccessLevel.READ_WRITE || policy.level == AccessLevel.READ_ONLY && store instanceof CoverageStoreInfo) {
            return store;
        }
        if (store instanceof DataStoreInfo) {
            return (T)new SecuredDataStoreInfo((DataStoreInfo)store, policy);
        }
        if (store instanceof CoverageStoreInfo) {
            return (T)new SecuredCoverageStoreInfo((CoverageStoreInfo)store, policy);
        }
        throw new RuntimeException("Unknown store type " + store.getClass());
    }

    protected LayerInfo checkAccess(Authentication user, LayerInfo layer) {
        boolean canWrite;
        if (layer == null) {
            return null;
        }
        boolean canRead = this.accessManager.canAccess(user, layer, AccessMode.READ);
        WrapperPolicy policy = this.checkWrapperPolicy(user, canRead, canWrite = this.accessManager.canAccess(user, layer, AccessMode.WRITE), layer.getName());
        if (policy == WrapperPolicy.HIDE) {
            return null;
        }
        if (policy.level == AccessLevel.READ_WRITE) {
            return layer;
        }
        return new SecuredLayerInfo(layer, policy);
    }

    protected LayerGroupInfo checkAccess(Authentication user, LayerGroupInfo group) {
        if (group == null) {
            return null;
        }
        List<LayerInfo> layers = group.getLayers();
        ArrayList<LayerInfo> wrapped = new ArrayList<LayerInfo>(layers.size());
        boolean needsWrapping = false;
        for (LayerInfo layer : layers) {
            LayerInfo checked = this.checkAccess(user, layer);
            if (checked == null) {
                return null;
            }
            if (checked != null && checked != layer) {
                needsWrapping = true;
            }
            wrapped.add(checked);
        }
        if (needsWrapping) {
            return new SecuredLayerGroupInfo(group, wrapped);
        }
        return group;
    }

    protected <T extends NamespaceInfo> T checkAccess(Authentication user, T ns) {
        WorkspaceInfo info;
        if (ns == null) {
            return null;
        }
        WorkspaceInfo ws = ((Catalog)this.delegate).getWorkspaceByName(ns.getPrefix());
        if (ws == null) {
            ws = ((Catalog)this.delegate).getFactory().createWorkspace();
            ws.setName(ns.getPrefix());
        }
        if ((info = this.checkAccess(user, ws)) == null) {
            return null;
        }
        return ns;
    }

    protected <T extends WorkspaceInfo> T checkAccess(Authentication user, T ws) {
        boolean canWrite;
        if (ws == null) {
            return null;
        }
        boolean canRead = this.accessManager.canAccess(user, ws, AccessMode.READ);
        WrapperPolicy policy = this.checkWrapperPolicy(user, canRead, canWrite = this.accessManager.canAccess(user, ws, AccessMode.WRITE), ws.getName());
        if (policy == WrapperPolicy.HIDE) {
            return null;
        }
        return ws;
    }

    WrapperPolicy checkWrapperPolicy(Authentication user, boolean canRead, boolean canWrite, String resourceName) {
        if (!canRead) {
            if (this.accessManager.getMode() == DataAccessManager.CatalogMode.HIDE) {
                return WrapperPolicy.HIDE;
            }
            if (this.accessManager.getMode() == DataAccessManager.CatalogMode.MIXED) {
                Request request = (Request)Dispatcher.REQUEST.get();
                if (request != null && "GetCapabilities".equalsIgnoreCase(request.getRequest())) {
                    return WrapperPolicy.HIDE;
                }
                throw SecureCatalogImpl.unauthorizedAccess(resourceName);
            }
            return WrapperPolicy.METADATA;
        }
        if (!canWrite) {
            if (this.accessManager.getMode() == DataAccessManager.CatalogMode.HIDE) {
                return WrapperPolicy.RO_HIDE;
            }
            return WrapperPolicy.RO_CHALLENGE;
        }
        return WrapperPolicy.RW;
    }

    public static AcegiSecurityException unauthorizedAccess(String resourceName) {
        Authentication user = SecureCatalogImpl.user();
        if (user == null || user.getAuthorities().length == 0) {
            return new InsufficientAuthenticationException("Cannot access " + resourceName + " as anonymous");
        }
        return new AccessDeniedException("Cannot access " + resourceName + " with the current privileges");
    }

    public static AcegiSecurityException unauthorizedAccess() {
        Authentication user = SecureCatalogImpl.user();
        if (user == null || user.getAuthorities().length == 0) {
            return new InsufficientAuthenticationException("Operation unallowed with the current privileges");
        }
        return new AccessDeniedException("Operation unallowed with the current privileges");
    }

    protected <T extends ResourceInfo> List<T> filterResources(Authentication user, List<T> resources) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        for (ResourceInfo original : resources) {
            ResourceInfo secured = this.checkAccess(user, original);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected <T extends StoreInfo> List<T> filterStores(Authentication user, List<T> resources) {
        ArrayList<StoreInfo> result = new ArrayList<StoreInfo>();
        for (StoreInfo original : resources) {
            StoreInfo secured = this.checkAccess(user, original);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected List<LayerGroupInfo> filterGroups(Authentication user, List<LayerGroupInfo> groups) {
        ArrayList<LayerGroupInfo> result = new ArrayList<LayerGroupInfo>();
        for (LayerGroupInfo original : groups) {
            LayerGroupInfo secured = this.checkAccess(user, original);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected List<LayerInfo> filterLayers(Authentication user, List<LayerInfo> layers) {
        ArrayList<LayerInfo> result = new ArrayList<LayerInfo>();
        for (LayerInfo original : layers) {
            LayerInfo secured = this.checkAccess(user, original);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected <T extends NamespaceInfo> List<T> filterNamespaces(Authentication user, List<T> namespaces) {
        ArrayList<NamespaceInfo> result = new ArrayList<NamespaceInfo>();
        for (NamespaceInfo original : namespaces) {
            NamespaceInfo secured = this.checkAccess(user, original);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected <T extends WorkspaceInfo> List<T> filterWorkspaces(Authentication user, List<T> workspaces) {
        ArrayList<WorkspaceInfo> result = new ArrayList<WorkspaceInfo>();
        for (WorkspaceInfo original : workspaces) {
            WorkspaceInfo secured = this.checkAccess(user, original);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    static LayerGroupInfo unwrap(LayerGroupInfo layerGroup) {
        if (layerGroup instanceof SecuredLayerGroupInfo) {
            return ((SecuredLayerGroupInfo)layerGroup).unwrap(LayerGroupInfo.class);
        }
        return layerGroup;
    }

    static LayerInfo unwrap(LayerInfo layer) {
        if (layer instanceof SecuredLayerInfo) {
            return ((SecuredLayerInfo)layer).unwrap(LayerInfo.class);
        }
        return layer;
    }

    static ResourceInfo unwrap(ResourceInfo info) {
        if (info instanceof SecuredFeatureTypeInfo) {
            return ((SecuredFeatureTypeInfo)info).unwrap(ResourceInfo.class);
        }
        return info;
    }

    static StoreInfo unwrap(StoreInfo info) {
        if (info instanceof SecuredDataStoreInfo) {
            return ((SecuredDataStoreInfo)info).unwrap(StoreInfo.class);
        }
        return info;
    }

    public static Object unwrap(Object obj) {
        if (obj instanceof LayerGroupInfo) {
            return SecureCatalogImpl.unwrap((LayerGroupInfo)obj);
        }
        if (obj instanceof LayerInfo) {
            return SecureCatalogImpl.unwrap((LayerInfo)obj);
        }
        if (obj instanceof ResourceInfo) {
            return SecureCatalogImpl.unwrap((ResourceInfo)obj);
        }
        if (obj instanceof StoreInfo) {
            return SecureCatalogImpl.unwrap((StoreInfo)obj);
        }
        if (obj instanceof SecureCatalogImpl) {
            return ((SecureCatalogImpl)obj).delegate;
        }
        return obj;
    }

    @Override
    public MapInfo getMap(String id) {
        return ((Catalog)this.delegate).getMap(id);
    }

    @Override
    public MapInfo getMapByName(String name) {
        return ((Catalog)this.delegate).getMapByName(name);
    }

    @Override
    public List<MapInfo> getMaps() {
        return ((Catalog)this.delegate).getMaps();
    }

    @Override
    public void add(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(layerGroup));
    }

    @Override
    public void add(LayerInfo layer) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(layer));
    }

    @Override
    public void add(MapInfo map) {
        ((Catalog)this.delegate).add(map);
    }

    @Override
    public void add(NamespaceInfo namespace) {
        ((Catalog)this.delegate).add(namespace);
    }

    @Override
    public void add(ResourceInfo resource) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(resource));
    }

    @Override
    public void add(StoreInfo store) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(store));
    }

    @Override
    public void add(StyleInfo style) {
        ((Catalog)this.delegate).add(style);
    }

    @Override
    public void add(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).add(workspace);
    }

    @Override
    public void addListener(CatalogListener listener) {
        ((Catalog)this.delegate).addListener(listener);
    }

    @Override
    public void dispose() {
        ((Catalog)this.delegate).dispose();
    }

    @Override
    public CatalogFactory getFactory() {
        return ((Catalog)this.delegate).getFactory();
    }

    @Override
    public Collection<CatalogListener> getListeners() {
        return ((Catalog)this.delegate).getListeners();
    }

    @Override
    public ResourcePool getResourcePool() {
        return ((Catalog)this.delegate).getResourcePool();
    }

    @Override
    public StyleInfo getStyle(String id) {
        return ((Catalog)this.delegate).getStyle(id);
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        return ((Catalog)this.delegate).getStyleByName(name);
    }

    @Override
    public List<StyleInfo> getStyles() {
        return ((Catalog)this.delegate).getStyles();
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(layerGroup));
    }

    @Override
    public void remove(LayerInfo layer) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(layer));
    }

    @Override
    public void remove(MapInfo map) {
        ((Catalog)this.delegate).remove(map);
    }

    @Override
    public void remove(NamespaceInfo namespace) {
        ((Catalog)this.delegate).remove(namespace);
    }

    @Override
    public void remove(ResourceInfo resource) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(resource));
    }

    @Override
    public void remove(StoreInfo store) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(store));
    }

    @Override
    public void remove(StyleInfo style) {
        ((Catalog)this.delegate).remove(style);
    }

    @Override
    public void remove(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).remove(workspace);
    }

    @Override
    public void removeListener(CatalogListener listener) {
        ((Catalog)this.delegate).removeListener(listener);
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(layerGroup));
    }

    @Override
    public void save(LayerInfo layer) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(layer));
    }

    @Override
    public void save(MapInfo map) {
        ((Catalog)this.delegate).save(map);
    }

    @Override
    public void save(NamespaceInfo namespace) {
        ((Catalog)this.delegate).save(namespace);
    }

    @Override
    public void save(ResourceInfo resource) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(resource));
    }

    @Override
    public void save(StoreInfo store) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(store));
    }

    @Override
    public void save(StyleInfo style) {
        ((Catalog)this.delegate).save(style);
    }

    @Override
    public void save(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).save(workspace);
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        ((Catalog)this.delegate).setDefaultNamespace(defaultNamespace);
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).setDefaultWorkspace(workspace);
    }

    @Override
    public void setResourcePool(ResourcePool resourcePool) {
        ((Catalog)this.delegate).setResourcePool(resourcePool);
    }

    @Override
    public GeoServerResourceLoader getResourceLoader() {
        return ((Catalog)this.delegate).getResourceLoader();
    }

    @Override
    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        ((Catalog)this.delegate).setResourceLoader(resourceLoader);
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        ((Catalog)this.delegate).accept(visitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WrapperPolicy {
        HIDE(AccessLevel.HIDDEN, Response.HIDE),
        METADATA(AccessLevel.METADATA, Response.CHALLENGE),
        RO_CHALLENGE(AccessLevel.READ_ONLY, Response.CHALLENGE),
        RO_HIDE(AccessLevel.READ_ONLY, Response.HIDE),
        RW(AccessLevel.READ_WRITE, Response.HIDE);

        public final AccessLevel level;
        public final Response response;

        private WrapperPolicy(AccessLevel level, Response response) {
            this.level = level;
            this.response = response;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Response {
        HIDE,
        CHALLENGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessLevel {
        HIDDEN,
        METADATA,
        READ_ONLY,
        READ_WRITE;

    }
}

