/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AbstractAccessRuleDAO;
import org.geoserver.security.ServiceAccessRule;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAccessRuleDAO
extends AbstractAccessRuleDAO<ServiceAccessRule> {
    static final String SERVICES = "services.properties";
    Catalog rawCatalog;

    public static ServiceAccessRuleDAO get() {
        return (ServiceAccessRuleDAO)GeoServerExtensions.bean(ServiceAccessRuleDAO.class);
    }

    public ServiceAccessRuleDAO(GeoServerDataDirectory dd, Catalog rawCatalog) throws IOException {
        super(dd, SERVICES);
        this.rawCatalog = rawCatalog;
    }

    public ServiceAccessRuleDAO() throws IOException {
        super(GeoserverDataDirectory.accessor(), SERVICES);
    }

    ServiceAccessRuleDAO(Catalog rawCatalog, File securityDir) {
        super(securityDir, SERVICES);
    }

    @Override
    protected void loadRules(Properties props) {
        TreeSet<ServiceAccessRule> result = new TreeSet<ServiceAccessRule>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String ruleValue;
            String ruleKey = (String)entry.getKey();
            ServiceAccessRule rule = this.parseServiceAccessRule(ruleKey, ruleValue = (String)entry.getValue());
            if (rule == null) continue;
            if (result.contains(rule)) {
                LOGGER.warning("Rule " + ruleKey + "." + ruleValue + " overwrites another rule on the same path");
            }
            result.add(rule);
        }
        if (result.size() == 0) {
            result.add(new ServiceAccessRule(new ServiceAccessRule()));
        }
        this.rules = result;
    }

    ServiceAccessRule parseServiceAccessRule(String ruleKey, String ruleValue) {
        String rule = ruleKey + "=" + ruleValue;
        String[] elements = this.parseElements(ruleKey);
        if (elements.length != 2) {
            LOGGER.warning("Invalid rule " + rule + ", the expected format is service.method=role1,role2,...");
            return null;
        }
        String service = elements[0];
        String method = elements[1];
        Set<String> roles = this.parseRoles(ruleValue);
        if ("*".equals(service) && !"*".equals(method)) {
            LOGGER.warning("Invalid rule " + rule + ", when namespace " + "is * then also layer must be *. Skipping rule " + rule);
            return null;
        }
        return new ServiceAccessRule(service, method, roles);
    }

    @Override
    protected Properties toProperties() {
        Properties props = new Properties();
        for (ServiceAccessRule rule : this.rules) {
            props.put(rule.getKey(), rule.getValue());
        }
        return props;
    }

    private String[] parseElements(String path) {
        return path.split("\\s*\\.\\s*");
    }

    static {
        LOGGER = Logging.getLogger(ServiceAccessRuleDAO.class);
    }
}

